/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.impl.client.deployment;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jboss.arquillian.impl.ThreadContext;
import org.jboss.arquillian.impl.client.deployment.AnnotationDeploymentScenarioGenerator;
import org.jboss.arquillian.impl.client.deployment.ValidationException;
import org.jboss.arquillian.impl.client.deployment.event.GenerateDeployment;
import org.jboss.arquillian.impl.domain.Container;
import org.jboss.arquillian.impl.domain.ContainerRegistry;
import org.jboss.arquillian.impl.domain.ProtocolDefinition;
import org.jboss.arquillian.impl.domain.ProtocolRegistry;
import org.jboss.arquillian.spi.ServiceLoader;
import org.jboss.arquillian.spi.TestClass;
import org.jboss.arquillian.spi.TestDeployment;
import org.jboss.arquillian.spi.client.deployment.ApplicationArchiveProcessor;
import org.jboss.arquillian.spi.client.deployment.AuxiliaryArchiveAppender;
import org.jboss.arquillian.spi.client.deployment.AuxiliaryArchiveProcessor;
import org.jboss.arquillian.spi.client.deployment.DeploymentDescription;
import org.jboss.arquillian.spi.client.deployment.DeploymentPackager;
import org.jboss.arquillian.spi.client.deployment.DeploymentScenario;
import org.jboss.arquillian.spi.client.deployment.DeploymentScenarioGenerator;
import org.jboss.arquillian.spi.client.deployment.ProtocolArchiveProcessor;
import org.jboss.arquillian.spi.client.protocol.Protocol;
import org.jboss.arquillian.spi.client.protocol.ProtocolDescription;
import org.jboss.arquillian.spi.client.test.TargetDescription;
import org.jboss.arquillian.spi.core.Instance;
import org.jboss.arquillian.spi.core.InstanceProducer;
import org.jboss.arquillian.spi.core.annotation.ClassScoped;
import org.jboss.arquillian.spi.core.annotation.Inject;
import org.jboss.arquillian.spi.core.annotation.Observes;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.container.ClassContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeploymentGenerator {
    @Inject
    private Instance<ServiceLoader> serviceLoader;
    @Inject
    @ClassScoped
    private InstanceProducer<DeploymentScenario> deployment;
    @Inject
    private Instance<ContainerRegistry> containerRegistry;
    @Inject
    private Instance<ProtocolRegistry> protocolRegistry;

    public void generateDeployment(@Observes GenerateDeployment event) {
        DeploymentScenarioGenerator generator = (DeploymentScenarioGenerator)((ServiceLoader)this.serviceLoader.get()).onlyOne(DeploymentScenarioGenerator.class, AnnotationDeploymentScenarioGenerator.class);
        DeploymentScenario scenario = generator.generate(event.getTestClass());
        this.validate(scenario);
        this.createTestableDeployments(scenario, event.getTestClass());
        this.deployment.set((Object)scenario);
    }

    protected void validate(DeploymentScenario scenario) {
        ContainerRegistry conReg = (ContainerRegistry)this.containerRegistry.get();
        for (TargetDescription target : scenario.getTargets()) {
            Container container = conReg.getContainer(target);
            if (container != null) continue;
            throw new ValidationException(DeploymentScenario.class.getSimpleName() + " contains targets not maching any defined Container in the registry. " + target.getName());
        }
        ProtocolRegistry proReg = (ProtocolRegistry)this.protocolRegistry.get();
        for (ProtocolDescription proDesc : scenario.getProtocols()) {
            ProtocolDefinition protocol;
            if (ProtocolDescription.DEFAULT.equals((Object)proDesc) || (protocol = proReg.getProtocol(proDesc)) != null) continue;
            throw new ValidationException(DeploymentScenario.class.getSimpleName() + " contains protcols not maching any defined Protocol in the registry. " + proDesc.getName());
        }
    }

    private void createTestableDeployments(DeploymentScenario scenario, TestClass testCase) {
        ProtocolRegistry protoReg = (ProtocolRegistry)this.protocolRegistry.get();
        this.buildTestableDeployments(scenario, testCase, protoReg);
    }

    private void buildTestableDeployments(DeploymentScenario scenario, TestClass testCase, ProtocolRegistry protoReg) {
        for (DeploymentDescription deployment : scenario.getDeployments()) {
            if (!deployment.testable() || !deployment.isArchiveDeployment()) continue;
            List<Archive<?>> auxiliaryArchives = this.loadAuxiliaryArchives(deployment);
            ProtocolDefinition protocolDefinition = protoReg.getProtocol(deployment.getProtocol());
            if (protocolDefinition == null) {
                protocolDefinition = protoReg.getProtocol(((ContainerRegistry)this.containerRegistry.get()).getContainer(deployment.getTarget()).getDeployableContainer().getDefaultProtocol());
            }
            Protocol<?> protocol = protocolDefinition.getProtocol();
            DeploymentPackager packager = protocol.getPackager();
            Archive applicationArchive = deployment.getArchive();
            this.applyApplicationProcessors(deployment.getArchive(), testCase);
            this.applyAuxiliaryProcessors(auxiliaryArchives);
            try {
                if (ClassContainer.class.isInstance(applicationArchive)) {
                    ClassContainer classContainer = (ClassContainer)ClassContainer.class.cast(applicationArchive);
                    classContainer.addClass(testCase.getJavaClass());
                }
            }
            catch (UnsupportedOperationException e) {
                // empty catch block
            }
            ClassLoader classLoader = ((ContainerRegistry)this.containerRegistry.get()).getContainer(deployment.getTarget()).getClassLoader();
            deployment.setTestableArchive(packager.generateDeployment(new TestDeployment(applicationArchive, auxiliaryArchives), ((ServiceLoader)this.serviceLoader.get()).all(classLoader, ProtocolArchiveProcessor.class)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Archive<?>> loadAuxiliaryArchives(DeploymentDescription deployment) {
        ArrayList archives = new ArrayList();
        ClassLoader classLoader = ((ContainerRegistry)this.containerRegistry.get()).getContainer(deployment.getTarget()).getClassLoader();
        Collection archiveAppenders = ((ServiceLoader)this.serviceLoader.get()).all(classLoader, AuxiliaryArchiveAppender.class);
        try {
            ThreadContext.set(classLoader);
            for (AuxiliaryArchiveAppender archiveAppender : archiveAppenders) {
                archives.add(archiveAppender.createAuxiliaryArchive());
            }
        }
        finally {
            ThreadContext.reset();
        }
        return archives;
    }

    private void applyApplicationProcessors(Archive<?> applicationArchive, TestClass testClass) {
        Collection processors = ((ServiceLoader)this.serviceLoader.get()).all(ApplicationArchiveProcessor.class);
        for (ApplicationArchiveProcessor processor : processors) {
            processor.process(applicationArchive, testClass);
        }
    }

    private void applyAuxiliaryProcessors(List<Archive<?>> auxiliaryArchives) {
        Collection processors = ((ServiceLoader)this.serviceLoader.get()).all(AuxiliaryArchiveProcessor.class);
        for (AuxiliaryArchiveProcessor processor : processors) {
            for (Archive<?> auxiliaryArchive : auxiliaryArchives) {
                processor.process(auxiliaryArchive);
            }
        }
    }
}

