/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.impl.domain;

import org.jboss.arquillian.impl.MapObject;
import org.jboss.arquillian.impl.Validate;
import org.jboss.arquillian.impl.configuration.api.ContainerDef;
import org.jboss.arquillian.impl.configuration.api.ProtocolDef;
import org.jboss.arquillian.spi.client.container.ContainerConfiguration;
import org.jboss.arquillian.spi.client.container.DeployableContainer;
import org.jboss.arquillian.spi.client.protocol.ProtocolDescription;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Container {
    private ClassLoader classLoader;
    private DeployableContainer<?> deployableContainer;
    private String name;
    private ContainerDef containerConfiguration;

    public Container(String name, ClassLoader classLoader, DeployableContainer<?> deployableContainer, ContainerDef containerConfiguration) {
        Validate.notNull(name, "Name must be specified");
        Validate.notNull(classLoader, "ClassLoader must be specified");
        Validate.notNull(deployableContainer, "DeployableContainer must be specified");
        Validate.notNull(containerConfiguration, "ConfigurationConfiguration must be specified");
        this.name = name;
        this.classLoader = classLoader;
        this.deployableContainer = deployableContainer;
        this.containerConfiguration = containerConfiguration;
    }

    public String getName() {
        return this.name;
    }

    public DeployableContainer<?> getDeployableContainer() {
        return this.deployableContainer;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public ContainerDef getContainerConfiguration() {
        return this.containerConfiguration;
    }

    public ContainerConfiguration createDeployableConfiguration() throws Exception {
        ContainerConfiguration config = (ContainerConfiguration)this.deployableContainer.getConfigurationClass().newInstance();
        MapObject.populate(config, this.containerConfiguration.getContainerProperties());
        config.validate();
        return config;
    }

    public boolean hasProtocolConfiguration(ProtocolDescription description) {
        for (ProtocolDef protocol : this.containerConfiguration.getProtocols()) {
            if (!description.getName().equals(protocol.getType())) continue;
            return true;
        }
        return false;
    }

    public ProtocolDef getProtocolConfiguration(ProtocolDescription description) {
        for (ProtocolDef protocol : this.containerConfiguration.getProtocols()) {
            if (!description.getName().equals(protocol.getType())) continue;
            return protocol;
        }
        return null;
    }
}

