/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.impl.domain;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.arquillian.impl.MapObject;
import org.jboss.arquillian.impl.Validate;
import org.jboss.arquillian.impl.configuration.api.ContainerDef;
import org.jboss.arquillian.impl.domain.Container;
import org.jboss.arquillian.impl.domain.ContainerCreationException;
import org.jboss.arquillian.impl.domain.FilteredURLClassLoader;
import org.jboss.arquillian.spi.ServiceLoader;
import org.jboss.arquillian.spi.client.container.DeployableContainer;
import org.jboss.arquillian.spi.client.test.TargetDescription;
import org.jboss.shrinkwrap.resolver.api.DependencyResolvers;
import org.jboss.shrinkwrap.resolver.api.maven.MavenDependencyResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContainerRegistry {
    private List<Container> containers = new ArrayList<Container>();

    public Container create(ContainerDef definition, ServiceLoader loader) {
        Validate.notNull(definition, "Definition must be specified");
        try {
            ClassLoader containerClassLoader;
            if (definition.getDependencies().size() > 0) {
                MavenDependencyResolver resolver = (MavenDependencyResolver)((MavenDependencyResolver)DependencyResolvers.use(MavenDependencyResolver.class)).artifacts(definition.getDependencies().toArray(new String[0]));
                URL[] resolvedURLs = MapObject.convert(resolver.resolveAsFiles());
                containerClassLoader = new FilteredURLClassLoader(resolvedURLs, "org.jboss.(arquillian|shrinkwrap)..*");
            } else {
                containerClassLoader = ContainerRegistry.class.getClassLoader();
            }
            return this.addContainer(new Container(definition.getContainerName(), containerClassLoader, (DeployableContainer)loader.onlyOne(containerClassLoader, DeployableContainer.class), definition));
        }
        catch (Exception e) {
            throw new ContainerCreationException("Could not create Container " + definition.getContainerName(), e);
        }
    }

    public Container getContainer(String name) {
        return this.findMatchingContainer(name);
    }

    public List<Container> getContainers() {
        return Collections.unmodifiableList(this.containers);
    }

    public Container getContainer(TargetDescription target) {
        Validate.notNull(target, "Target must be specified");
        if (TargetDescription.DEFAULT.equals((Object)target)) {
            return this.findDefaultContainer();
        }
        return this.findMatchingContainer(target.getName());
    }

    private Container addContainer(Container contianer) {
        this.containers.add(contianer);
        return contianer;
    }

    private Container findDefaultContainer() {
        if (this.containers.size() == 1) {
            return this.containers.get(0);
        }
        for (Container container : this.containers) {
            if (!container.getContainerConfiguration().isDefault()) continue;
            return container;
        }
        return null;
    }

    private Container findMatchingContainer(String name) {
        for (Container container : this.containers) {
            if (!container.getName().equals(name)) continue;
            return container;
        }
        return null;
    }
}

