/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.impl.execution;

import org.jboss.arquillian.impl.domain.Container;
import org.jboss.arquillian.impl.domain.ProtocolDefinition;
import org.jboss.arquillian.impl.domain.ProtocolRegistry;
import org.jboss.arquillian.impl.execution.event.RemoteExecutionEvent;
import org.jboss.arquillian.spi.ContainerMethodExecutor;
import org.jboss.arquillian.spi.TestResult;
import org.jboss.arquillian.spi.client.deployment.DeploymentDescription;
import org.jboss.arquillian.spi.client.protocol.ProtocolConfiguration;
import org.jboss.arquillian.spi.client.protocol.metadata.ProtocolMetaData;
import org.jboss.arquillian.spi.core.Instance;
import org.jboss.arquillian.spi.core.InstanceProducer;
import org.jboss.arquillian.spi.core.annotation.Inject;
import org.jboss.arquillian.spi.core.annotation.Observes;
import org.jboss.arquillian.spi.core.annotation.TestScoped;

public class RemoteTestExecuter {
    @Inject
    private Instance<DeploymentDescription> deployment;
    @Inject
    private Instance<Container> container;
    @Inject
    private Instance<ProtocolRegistry> protocolRegistry;
    @Inject
    private Instance<ProtocolMetaData> protocolMetadata;
    @Inject
    @TestScoped
    private InstanceProducer<TestResult> testResult;

    public void execute(@Observes RemoteExecutionEvent event) throws Exception {
        Container container = (Container)this.container.get();
        DeploymentDescription deployment = (DeploymentDescription)this.deployment.get();
        ProtocolRegistry protoReg = (ProtocolRegistry)this.protocolRegistry.get();
        ProtocolDefinition protocol = protoReg.getProtocol(deployment.getProtocol());
        if (protocol == null) {
            protocol = protoReg.getProtocol(container.getDeployableContainer().getDefaultProtocol());
        }
        ProtocolConfiguration protocolConfiguration = container.hasProtocolConfiguration(protocol.getProtocolDescription()) ? protocol.createProtocolConfiguration(container.getProtocolConfiguration(protocol.getProtocolDescription()).getProtocolProperties()) : protocol.createProtocolConfiguration();
        ContainerMethodExecutor executor = this.getContainerMethodExecutor(protocol, protocolConfiguration);
        this.testResult.set((Object)executor.invoke(event.getExecutor()));
    }

    public ContainerMethodExecutor getContainerMethodExecutor(ProtocolDefinition protocol, ProtocolConfiguration protocolConfiguration) {
        ContainerMethodExecutor executor = protocol.getProtocol().getExecutor(protocolConfiguration, (ProtocolMetaData)this.protocolMetadata.get());
        return executor;
    }
}

