/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.spi;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import org.jboss.arquillian.spi.ArquillianProxyException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExceptionProxy
implements Serializable {
    private static final long serialVersionUID = 2321010311438950147L;
    private String className;
    private String message;
    private StackTraceElement[] trace;
    private ExceptionProxy causeProxy;
    private Throwable cause;

    public ExceptionProxy(Throwable throwable) {
        this.className = throwable.getClass().getName();
        this.message = throwable.getMessage();
        this.trace = throwable.getStackTrace();
        this.causeProxy = ExceptionProxy.createForException(throwable.getCause());
    }

    public String toString() {
        return super.toString() + String.format("[class=%s, message=%s],cause = %s", this.className, this.message, this.causeProxy);
    }

    public boolean hasException() {
        return this.className != null;
    }

    public Throwable createException() {
        if (!this.hasException()) {
            return null;
        }
        Class<?> clazz = null;
        try {
            clazz = Class.forName(this.className);
        }
        catch (ClassNotFoundException e) {
            return this.createProxyException("Exception class not found on client");
        }
        Throwable throwable = this.constructExceptionForClass(clazz);
        throwable.setStackTrace(this.trace);
        return throwable;
    }

    public ArquillianProxyException createProxyException(String reason) {
        ArquillianProxyException exception = new ArquillianProxyException(this.message, this.className, reason, this.getCause());
        exception.setStackTrace(this.trace);
        return exception;
    }

    private Throwable constructExceptionForClass(Class<?> clazz) {
        Object object = this.buildObjectFromClassConstructors(clazz);
        if (object == null) {
            return this.createProxyException("Could not find suitable constructor");
        }
        if (!(object instanceof Throwable)) {
            return this.createProxyException("Proxy references non-Throwable type");
        }
        return (Throwable)object;
    }

    private Object buildObjectFromClassConstructors(Class<?> clazz) {
        Object object = this.buildExceptionFromConstructor(clazz, new Class[]{String.class, Throwable.class}, new Object[]{this.message, this.getCause()});
        if (object != null) {
            return object;
        }
        object = this.buildExceptionFromConstructor(clazz, new Class[]{String.class, Exception.class}, new Object[]{this.message, this.getCause()});
        if (object != null) {
            return object;
        }
        object = this.buildExceptionFromConstructor(clazz, new Class[]{String.class}, new Object[]{this.message});
        if (object != null) {
            return object;
        }
        return null;
    }

    private <T> T buildExceptionFromConstructor(Class<T> clazz, Class<?>[] signature, Object[] params) {
        Constructor<T> constructor = null;
        try {
            constructor = clazz.getConstructor(signature);
        }
        catch (SecurityException e) {
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        if (constructor != null) {
            try {
                T result = constructor.newInstance(params);
                return result;
            }
            catch (Throwable e) {
                return null;
            }
        }
        return null;
    }

    public static ExceptionProxy createForException(Throwable throwable) {
        if (throwable == null) {
            return null;
        }
        return new ExceptionProxy(throwable);
    }

    public Throwable getCause() {
        if (this.cause == null && this.causeProxy != null) {
            this.cause = this.causeProxy.createException();
        }
        return this.cause;
    }
}

