/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.spi.client.deployment;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jboss.arquillian.spi.client.deployment.DeploymentDescription;
import org.jboss.arquillian.spi.client.protocol.ProtocolDescription;
import org.jboss.arquillian.spi.client.test.DeploymentTargetDescription;
import org.jboss.arquillian.spi.client.test.TargetDescription;
import org.jboss.arquillian.spi.util.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeploymentScenario {
    private List<DeploymentDescription> deployments = new ArrayList<DeploymentDescription>();

    public DeploymentScenario addDeployment(DeploymentDescription deployment) {
        Validate.notNull(deployment, "Deployment must be specified");
        this.deployments.add(deployment);
        return this;
    }

    public Set<TargetDescription> getTargets() {
        HashSet<TargetDescription> targets = new HashSet<TargetDescription>();
        for (DeploymentDescription desc : this.deployments) {
            targets.add(desc.getTarget());
        }
        return targets;
    }

    public Set<ProtocolDescription> getProtocols() {
        HashSet<ProtocolDescription> protocols = new HashSet<ProtocolDescription>();
        for (DeploymentDescription desc : this.deployments) {
            protocols.add(desc.getProtocol());
        }
        return protocols;
    }

    public DeploymentDescription getDeployment(DeploymentTargetDescription target) {
        Validate.notNull(target, "Target must be specified");
        if (DeploymentTargetDescription.DEFAULT.equals(target)) {
            return this.findDefaultDeployment();
        }
        return this.findMatchingDeployment(target);
    }

    private DeploymentDescription findDefaultDeployment() {
        if (this.deployments.size() == 1) {
            return this.deployments.get(0);
        }
        return null;
    }

    private DeploymentDescription findMatchingDeployment(DeploymentTargetDescription target) {
        for (DeploymentDescription deployment : this.deployments) {
            if (!deployment.getName().equals(target.getName())) continue;
            return deployment;
        }
        return null;
    }

    public List<DeploymentDescription> getStartupDeploymentsFor(TargetDescription target) {
        Validate.notNull(target, "Target must be specified");
        ArrayList<DeploymentDescription> startupDeployments = new ArrayList<DeploymentDescription>();
        for (DeploymentDescription deployment : this.deployments) {
            if (!deployment.managed() || !target.equals(deployment.getTarget())) continue;
            startupDeployments.add(deployment);
        }
        Collections.sort(startupDeployments, new Comparator<DeploymentDescription>(){

            @Override
            public int compare(DeploymentDescription o1, DeploymentDescription o2) {
                return new Integer(o1.getOrder()).compareTo(o2.getOrder());
            }
        });
        return Collections.unmodifiableList(startupDeployments);
    }

    public List<DeploymentDescription> getDeployments() {
        return Collections.unmodifiableList(this.deployments);
    }
}

