/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.impl.client.container;

import org.jboss.arquillian.container.spi.Container;
import org.jboss.arquillian.container.spi.ContainerRegistry;
import org.jboss.arquillian.container.spi.client.container.DeployableContainer;
import org.jboss.arquillian.container.spi.context.annotation.ContainerScoped;
import org.jboss.arquillian.container.spi.event.SetupContainer;
import org.jboss.arquillian.container.spi.event.SetupContainers;
import org.jboss.arquillian.container.spi.event.StartContainer;
import org.jboss.arquillian.container.spi.event.StartManagedContainers;
import org.jboss.arquillian.container.spi.event.StopContainer;
import org.jboss.arquillian.container.spi.event.StopManagedContainers;
import org.jboss.arquillian.container.spi.event.container.AfterSetup;
import org.jboss.arquillian.container.spi.event.container.AfterStart;
import org.jboss.arquillian.container.spi.event.container.AfterStop;
import org.jboss.arquillian.container.spi.event.container.BeforeSetup;
import org.jboss.arquillian.container.spi.event.container.BeforeStart;
import org.jboss.arquillian.container.spi.event.container.BeforeStop;
import org.jboss.arquillian.container.spi.event.container.ContainerEvent;
import org.jboss.arquillian.core.api.Event;
import org.jboss.arquillian.core.api.Injector;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.InstanceProducer;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;

public class ContainerLifecycleController {
    @Inject
    private Instance<ContainerRegistry> containerRegistry;
    @Inject
    private Instance<Injector> injector;

    public void setupContainers(@Observes SetupContainers event) throws Exception {
        this.forEachContainer(new Operation<Container>(){
            @Inject
            private Event<SetupContainer> event;

            @Override
            public void perform(Container container) {
                this.event.fire((Object)new SetupContainer(container));
            }
        });
    }

    public void startContainers(@Observes StartManagedContainers event) throws Exception {
        this.forEachContainer(new Operation<Container>(){
            @Inject
            private Event<StartContainer> event;

            @Override
            public void perform(Container container) {
                this.event.fire((Object)new StartContainer(container));
            }
        });
    }

    public void stopContainers(@Observes StopManagedContainers event) throws Exception {
        this.forEachContainer(new Operation<Container>(){
            @Inject
            private Event<StopContainer> stopContainer;

            @Override
            public void perform(Container container) {
                this.stopContainer.fire((Object)new StopContainer(container));
            }
        });
    }

    public void setupContainer(@Observes SetupContainer event) throws Exception {
        this.forContainer(event.getContainer(), new Operation<Container>(){
            @Inject
            private Event<ContainerEvent> event;
            @Inject
            @ContainerScoped
            private InstanceProducer<Container> containerProducer;

            @Override
            public void perform(Container container) throws Exception {
                this.containerProducer.set((Object)container);
                DeployableContainer deployable = container.getDeployableContainer();
                this.event.fire((Object)new BeforeSetup(deployable));
                deployable.setup(container.createDeployableConfiguration());
                this.event.fire((Object)new AfterSetup(deployable));
            }
        });
    }

    public void startContainer(@Observes StartContainer event) throws Exception {
        this.forContainer(event.getContainer(), new Operation<Container>(){
            @Inject
            private Event<ContainerEvent> event;

            @Override
            public void perform(Container container) throws Exception {
                DeployableContainer deployable = container.getDeployableContainer();
                this.event.fire((Object)new BeforeStart(deployable));
                deployable.start();
                this.event.fire((Object)new AfterStart(deployable));
            }
        });
    }

    public void stopContainer(@Observes StopContainer event) throws Exception {
        this.forContainer(event.getContainer(), new Operation<Container>(){
            @Inject
            private Event<ContainerEvent> event;

            @Override
            public void perform(Container container) throws Exception {
                DeployableContainer deployable = container.getDeployableContainer();
                this.event.fire((Object)new BeforeStop(deployable));
                deployable.stop();
                this.event.fire((Object)new AfterStop(deployable));
            }
        });
    }

    private void forEachContainer(Operation<Container> operation) throws Exception {
        ((Injector)this.injector.get()).inject(operation);
        ContainerRegistry registry = (ContainerRegistry)this.containerRegistry.get();
        for (Container container : registry.getContainers()) {
            operation.perform(container);
        }
    }

    private void forContainer(Container container, Operation<Container> operation) throws Exception {
        ((Injector)this.injector.get()).inject(operation);
        operation.perform(container);
    }

    public static interface Operation<T> {
        public void perform(T var1) throws Exception;
    }
}

