/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.glassfish.remote_3_1;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.multipart.FormDataMultiPart;
import com.sun.jersey.multipart.file.FileDataBodyPart;
import java.io.File;
import java.io.StringReader;
import javax.ws.rs.core.MediaType;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.jboss.arquillian.container.glassfish.remote_3_1.GlassFishRestConfiguration;
import org.jboss.arquillian.spi.client.container.DeployableContainer;
import org.jboss.arquillian.spi.client.container.DeploymentException;
import org.jboss.arquillian.spi.client.container.LifecycleException;
import org.jboss.arquillian.spi.client.protocol.ProtocolDescription;
import org.jboss.arquillian.spi.client.protocol.metadata.HTTPContext;
import org.jboss.arquillian.spi.client.protocol.metadata.ProtocolMetaData;
import org.jboss.arquillian.spi.client.protocol.metadata.Servlet;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.descriptor.api.Descriptor;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlassFishRestDeployableContainer
implements DeployableContainer<GlassFishRestConfiguration> {
    private static final String APPLICATION = "/applications/application";
    private static final String LIST_SUB_COMPONENTS = "/applications/application/list-sub-components?id=";
    private static final String SUCCESS = "SUCCESS";
    private String adminBaseUrl;
    private String applicationBaseUrl;
    private String deploymentName;
    private GlassFishRestConfiguration configuration;

    public Class<GlassFishRestConfiguration> getConfigurationClass() {
        return GlassFishRestConfiguration.class;
    }

    public void setup(GlassFishRestConfiguration configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException("configuration must not be null");
        }
        this.configuration = configuration;
        StringBuilder adminUrlBuilder = new StringBuilder();
        if (this.configuration.isRemoteServerAdminHttps()) {
            adminUrlBuilder.append("https://");
        } else {
            adminUrlBuilder.append("http://");
        }
        adminUrlBuilder.append(this.configuration.getRemoteServerAddress()).append(":").append(this.configuration.getRemoteServerAdminPort()).append("/management/domain");
        this.adminBaseUrl = adminUrlBuilder.toString();
        StringBuilder applicationUrlBuilder = new StringBuilder();
        if (this.configuration.isRemoteServerHttps()) {
            applicationUrlBuilder.append("https://");
        } else {
            applicationUrlBuilder.append("http://");
        }
        applicationUrlBuilder.append(this.configuration.getRemoteServerAddress()).append(":").append(this.configuration.getRemoteServerHttpPort()).append("/");
        this.applicationBaseUrl = applicationUrlBuilder.toString();
    }

    public void start() throws LifecycleException {
        String xmlResponse = (String)this.prepareClient().get(String.class);
        try {
            if (!this.isCallSuccessful(xmlResponse)) {
                throw new LifecycleException("Server is not running");
            }
        }
        catch (XPathExpressionException e) {
            throw new LifecycleException("Error verifying the sever is running", (Throwable)e);
        }
    }

    public void stop() throws LifecycleException {
    }

    public ProtocolDescription getDefaultProtocol() {
        return new ProtocolDescription("Servlet 3.0");
    }

    public ProtocolMetaData deploy(Archive<?> archive) throws DeploymentException {
        if (archive == null) {
            throw new IllegalArgumentException("archive must not be null");
        }
        String archiveName = archive.getName();
        try {
            File archiveFile = new File(new File(System.getProperty("java.io.tmpdir")), archiveName);
            ((ZipExporter)archive.as(ZipExporter.class)).exportZip(archiveFile, true);
            FormDataMultiPart form = new FormDataMultiPart();
            form.getBodyParts().add(new FileDataBodyPart("id", archiveFile));
            form.field("contextroot", (Object)archiveName.substring(0, archiveName.lastIndexOf(".")), MediaType.TEXT_PLAIN_TYPE);
            this.deploymentName = archiveName.substring(0, archiveName.lastIndexOf("."));
            form.field("name", (Object)this.deploymentName, MediaType.TEXT_PLAIN_TYPE);
            String xmlResponse = (String)((WebResource.Builder)this.prepareClient(APPLICATION).type(MediaType.MULTIPART_FORM_DATA_TYPE)).post(String.class, (Object)form);
            try {
                if (!this.isCallSuccessful(xmlResponse)) {
                    throw new DeploymentException(this.getMessage(xmlResponse));
                }
            }
            catch (XPathExpressionException e) {
                throw new DeploymentException("Error finding exit code or message", (Throwable)e);
            }
            String subComponentsResponse = (String)this.prepareClient(LIST_SUB_COMPONENTS + this.deploymentName).get(String.class);
            return this.parseForProtocolMetaData(subComponentsResponse);
        }
        catch (XPathExpressionException e) {
            throw new DeploymentException("Error in creating / deploying archive", (Throwable)e);
        }
    }

    public void undeploy(Archive<?> archive) throws DeploymentException {
        String xmlResponse = (String)this.prepareClient("/applications/application/" + this.deploymentName).delete(String.class);
        try {
            if (!this.isCallSuccessful(xmlResponse)) {
                throw new DeploymentException(this.getMessage(xmlResponse));
            }
        }
        catch (XPathExpressionException e) {
            throw new DeploymentException("Error finding exit code or message", (Throwable)e);
        }
    }

    public void deploy(Descriptor descriptor) throws DeploymentException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void undeploy(Descriptor descriptor) throws DeploymentException {
        throw new UnsupportedOperationException("Not implemented");
    }

    private WebResource.Builder prepareClient() {
        return this.prepareClient("");
    }

    private WebResource.Builder prepareClient(String additionalResourceUrl) {
        Client client = Client.create();
        return client.resource(this.adminBaseUrl + additionalResourceUrl).accept(new MediaType[]{MediaType.APPLICATION_XML_TYPE});
    }

    private boolean isCallSuccessful(String xmlResponse) throws XPathExpressionException {
        XPath xpath = XPathFactory.newInstance().newXPath();
        String exitCode = xpath.evaluate("/map/entry[@key = 'exit_code']/@value", new InputSource(new StringReader(xmlResponse)));
        return exitCode != null && SUCCESS.equals(exitCode);
    }

    private String getMessage(String xmlResponse) throws XPathExpressionException {
        XPath xpath = XPathFactory.newInstance().newXPath();
        return xpath.evaluate("/map/entry[@key = 'message']/@value", new InputSource(new StringReader(xmlResponse)));
    }

    private ProtocolMetaData parseForProtocolMetaData(String xmlResponse) throws XPathExpressionException {
        ProtocolMetaData protocolMetaData = new ProtocolMetaData();
        HTTPContext httpContext = new HTTPContext(this.configuration.getRemoteServerAddress(), this.configuration.getRemoteServerHttpPort());
        XPath xpath = XPathFactory.newInstance().newXPath();
        NodeList servlets = (NodeList)xpath.evaluate("/map/entry[@key = 'properties']/map/entry[@value = 'Servlet']", new InputSource(new StringReader(xmlResponse)), XPathConstants.NODESET);
        for (int i = 0; i < servlets.getLength(); ++i) {
            httpContext.add(new Servlet(servlets.item(i).getAttributes().getNamedItem("key").getNodeValue(), this.deploymentName));
        }
        protocolMetaData.addContext((Object)httpContext);
        return protocolMetaData;
    }
}

