/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.openejb.embedded_3_1;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import javax.naming.Context;
import org.apache.openejb.NoSuchApplicationException;
import org.apache.openejb.OpenEJB;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.UndeployException;
import org.apache.openejb.assembler.classic.AppInfo;
import org.apache.openejb.assembler.classic.Assembler;
import org.apache.openejb.client.LocalInitialContextFactory;
import org.apache.openejb.loader.SystemInstance;
import org.jboss.arquillian.container.openejb.embedded_3_1.OpenEJBAssembler;
import org.jboss.arquillian.container.openejb.embedded_3_1.OpenEJBConfiguration;
import org.jboss.arquillian.container.spi.client.container.DeployableContainer;
import org.jboss.arquillian.container.spi.client.container.DeploymentException;
import org.jboss.arquillian.container.spi.client.container.LifecycleException;
import org.jboss.arquillian.container.spi.client.protocol.ProtocolDescription;
import org.jboss.arquillian.container.spi.client.protocol.metadata.ProtocolMetaData;
import org.jboss.arquillian.container.spi.context.annotation.ContainerScoped;
import org.jboss.arquillian.container.spi.context.annotation.DeploymentScoped;
import org.jboss.arquillian.core.api.InstanceProducer;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.descriptor.api.Descriptor;
import org.jboss.shrinkwrap.openejb.config.ShrinkWrapConfigurationFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenEJBContainer
implements DeployableContainer<OpenEJBConfiguration> {
    private Assembler assembler;
    private ShrinkWrapConfigurationFactory config;
    private OpenEJBConfiguration containerConfig;
    @Inject
    @DeploymentScoped
    private InstanceProducer<AppInfo> deployment;
    @Inject
    @ContainerScoped
    private InstanceProducer<Context> jndiContext;

    public ProtocolDescription getDefaultProtocol() {
        return new ProtocolDescription("Local");
    }

    public Class<OpenEJBConfiguration> getConfigurationClass() {
        return OpenEJBConfiguration.class;
    }

    public void setup(OpenEJBConfiguration configuration) {
        this.containerConfig = configuration;
    }

    public void deploy(Descriptor descriptor) throws DeploymentException {
        throw new UnsupportedOperationException("deploy Descriptor not supported");
    }

    public void undeploy(Descriptor descriptor) throws DeploymentException {
        throw new UnsupportedOperationException("undeploy Descriptor not supported");
    }

    public ProtocolMetaData deploy(Archive<?> archive) throws DeploymentException {
        AppInfo appInfo;
        try {
            appInfo = this.config.configureApplication(archive);
            this.deployment.set((Object)appInfo);
        }
        catch (OpenEJBException e) {
            throw new DeploymentException("Could not configure application in OpenEJB", (Throwable)e);
        }
        try {
            this.assembler.createApplication(appInfo);
        }
        catch (Exception ne) {
            throw new DeploymentException("Could not create the application", (Throwable)ne);
        }
        return new ProtocolMetaData();
    }

    public void start() throws LifecycleException {
        ShrinkWrapConfigurationFactory config = null;
        OpenEJBAssembler assembler = null;
        try {
            OpenEJB.init((Properties)this.getInitialProperties());
            assembler = (OpenEJBAssembler)((Object)SystemInstance.get().getComponent(Assembler.class));
            config = (ShrinkWrapConfigurationFactory)assembler.getConfigurationFactory();
            this.jndiContext.set((Object)assembler.getContainerSystem().getJNDIContext());
        }
        catch (Exception e) {
            throw new LifecycleException("Could not configure the OpenEJB Container", (Throwable)e);
        }
        this.assembler = assembler;
        this.config = config;
    }

    public void stop() throws LifecycleException {
        this.assembler.destroy();
    }

    public void undeploy(Archive<?> archive) throws DeploymentException {
        String deploymentName = archive.getName();
        try {
            this.assembler.destroyApplication(((AppInfo)this.deployment.get()).jarPath);
        }
        catch (UndeployException e) {
            throw new DeploymentException("Error in undeployment of " + deploymentName, (Throwable)e);
        }
        catch (NoSuchApplicationException e) {
            throw new DeploymentException("Application was not deployed; cannot undeploy: " + deploymentName, (Throwable)e);
        }
    }

    private Properties getInitialProperties() throws IOException {
        FileInputStream jndiPropertiesStream;
        File jndiPropertiesFile;
        Properties properties = new Properties();
        properties.put("java.naming.factory.initial", LocalInitialContextFactory.class.getName());
        if (this.containerConfig.getJndiProperties() != null && (jndiPropertiesFile = new File(this.containerConfig.getJndiProperties())).exists() && (jndiPropertiesStream = new FileInputStream(jndiPropertiesFile)) != null) {
            properties.load(jndiPropertiesStream);
        }
        properties.put("openejb.deployments.classpath", "false");
        properties.put("openejb.configurator", ShrinkWrapConfigurationFactory.class.getName());
        properties.put("openejb.assembler", OpenEJBAssembler.class.getName());
        if (this.containerConfig.getOpenEjbXml() != null) {
            properties.put("openejb.configuration", this.containerConfig.getOpenEjbXml());
        }
        return properties;
    }
}

