/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.openejb.embedded_3_1;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.annotation.Resource;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.resource.spi.ResourceAdapter;
import javax.sql.DataSource;
import javax.transaction.UserTransaction;
import org.jboss.arquillian.container.openejb.embedded_3_1.SecurityActions;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.test.spi.TestEnricher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenEJBResourceInjectionEnricher
implements TestEnricher {
    private static final String RESOURCE_LOOKUP_PREFIX = "java:/comp/env";
    private static final String ANNOTATION_NAME = "javax.annotation.Resource";
    private static final Logger log = Logger.getLogger(OpenEJBResourceInjectionEnricher.class.getName());
    @Inject
    private Instance<Context> contextInst;
    private static final String RESOURCE_ADAPTER_LOOKUP_PREFIX = "openejb/Resource";

    public void enrich(Object testCase) {
        if (SecurityActions.isClassPresent(ANNOTATION_NAME) && this.contextInst.get() != null) {
            this.injectClass(testCase);
        }
    }

    public Object[] resolve(Method method) {
        return new Object[method.getParameterTypes().length];
    }

    protected void injectClass(Object testCase) {
        try {
            Object resource;
            Class<?> resourceAnnotation = SecurityActions.getThreadContextClassLoader().loadClass(ANNOTATION_NAME);
            List<Field> annotatedFields = SecurityActions.getFieldsWithAnnotation(testCase.getClass(), resourceAnnotation);
            for (Field field : annotatedFields) {
                Object currentValue;
                if (!this.shouldInject(field, currentValue = field.get(testCase))) continue;
                resource = this.resolveResource(field);
                field.set(testCase, resource);
            }
            List<Method> methods = SecurityActions.getMethodsWithAnnotation(testCase.getClass(), resourceAnnotation);
            for (Method method : methods) {
                if (method.getParameterTypes().length != 1) {
                    throw new RuntimeException("@Resource only allowed on single argument methods");
                }
                if (!method.getName().startsWith("set")) {
                    throw new RuntimeException("@Resource only allowed on 'set' methods");
                }
                resource = this.resolveResource(method);
                method.invoke(testCase, resource);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Could not inject members", e);
        }
    }

    private boolean shouldInject(Field field, Object currentValue) {
        Class<?> type = field.getType();
        if (type.isPrimitive()) {
            if (this.isPrimitiveNull(currentValue)) {
                log.fine("Primitive field " + field.getName() + " has been detected to have the default primitive value, " + "can not determine if it has already been injected. Re-injecting field.");
                return true;
            }
        } else if (currentValue == null) {
            return true;
        }
        return false;
    }

    private boolean isPrimitiveNull(Object currentValue) {
        String stringValue = String.valueOf(currentValue);
        if ("0".equals(stringValue) || "0.0".equals(stringValue) || "false".equals(stringValue)) {
            return true;
        }
        return Character.class.isInstance(currentValue) && ((Character)Character.class.cast(currentValue)).charValue() == '\u0000';
    }

    protected Object lookup(String jndiName) throws Exception {
        Context context = this.getContainerContext();
        return context.lookup(jndiName);
    }

    protected Context getContainerContext() throws NamingException {
        return (Context)this.contextInst.get();
    }

    protected String getResourceName(Field field) {
        Resource resource = field.getAnnotation(Resource.class);
        String resourceName = this.getResourceName(resource);
        if (resourceName != null) {
            return resourceName;
        }
        String propertyName = field.getName();
        String className = field.getDeclaringClass().getName();
        return "java:/comp/env/" + className + "/" + propertyName;
    }

    protected String getResourceName(Resource resource) {
        String mappedName = resource.mappedName();
        if (!mappedName.equals("")) {
            return mappedName;
        }
        String name = resource.name();
        if (!name.equals("")) {
            return "java:/comp/env/" + name;
        }
        return null;
    }

    protected Object resolveResource(AnnotatedElement element) throws Exception {
        Object resolvedResource = null;
        Class<?> resourceType = null;
        if (Field.class.isAssignableFrom(element.getClass())) {
            resourceType = ((Field)element).getType();
        } else if (Method.class.isAssignableFrom(element.getClass())) {
            resourceType = ((Method)element).getParameterTypes()[0];
        }
        if (resourceType == null) {
            throw new IllegalStateException("No type found for resource injection target " + element);
        }
        if (ResourceAdapter.class.isAssignableFrom(resourceType) || DataSource.class.isAssignableFrom(resourceType)) {
            Resource resourceAnnotation = element.getAnnotation(Resource.class);
            resolvedResource = !resourceAnnotation.name().equals("") ? this.lookup("openejb/Resource/" + resourceAnnotation.name()) : (!resourceAnnotation.mappedName().equals("") ? this.lookup(resourceAnnotation.mappedName()) : this.findResourceByType(resourceType));
        } else if (UserTransaction.class.isAssignableFrom(resourceType)) {
            resolvedResource = this.lookup("java:comp/UserTransaction");
        }
        return resolvedResource;
    }

    private Object findResourceByType(Class<?> resourceType) throws NamingException {
        NamingEnumeration<Binding> namingEnumeration = null;
        try {
            namingEnumeration = this.getContainerContext().listBindings(RESOURCE_ADAPTER_LOOKUP_PREFIX);
        }
        catch (NamingException ignore) {
            // empty catch block
        }
        ArrayList<Object> resourceMatches = new ArrayList<Object>();
        while (namingEnumeration != null && namingEnumeration.hasMoreElements()) {
            Binding binding = namingEnumeration.next();
            Object boundResource = binding.getObject();
            if (!resourceType.isAssignableFrom(boundResource.getClass())) continue;
            resourceMatches.add(boundResource);
        }
        if (resourceMatches.size() == 1) {
            return resourceMatches.get(0);
        }
        if (resourceMatches.size() > 1) {
            return resourceMatches.get(0);
        }
        throw new RuntimeException("Could not inject resource of type " + resourceType);
    }
}

