/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.drone.impl;

import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.arquillian.drone.api.annotation.Default;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DroneContext {
    private Map<QualifiedKey, Object> cache = new ConcurrentHashMap<QualifiedKey, Object>();

    public <T> T get(Class<T> key) {
        return key.cast(this.cache.get(new QualifiedKey(key, Default.class)));
    }

    public <T> T get(Class<T> key, Class<? extends Annotation> qualifier) {
        return key.cast(this.cache.get(new QualifiedKey(key, qualifier)));
    }

    public <T> DroneContext add(Class<T> key, T instance) {
        this.cache.put(new QualifiedKey(key, Default.class), instance);
        return this;
    }

    public <T> DroneContext add(Class<?> key, Class<? extends Annotation> qualifier, T instance) {
        this.cache.put(new QualifiedKey(key, qualifier), instance);
        return this;
    }

    public DroneContext remove(Class<?> key) {
        this.cache.remove(new QualifiedKey(key, Default.class));
        return this;
    }

    public DroneContext remove(Class<?> key, Class<? extends Annotation> qualifier) {
        this.cache.remove(new QualifiedKey(key, qualifier));
        return this;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class QualifiedKey {
        private Class<?> key;
        private Class<? extends Annotation> qualifier;

        public QualifiedKey(Class<?> key, Class<? extends Annotation> qualifier) {
            this.key = key;
            this.qualifier = qualifier;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.qualifier == null ? 0 : this.qualifier.hashCode());
            result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            QualifiedKey other = (QualifiedKey)obj;
            if (this.qualifier == null ? other.qualifier != null : !this.qualifier.equals(other.qualifier)) {
                return false;
            }
            return !(this.key == null ? other.key != null : !this.key.equals(other.key));
        }

        public String toString() {
            return this.key.getName() + "/" + this.qualifier.getSimpleName();
        }
    }
}

