/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.drone.impl;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import org.jboss.arquillian.container.test.api.OperateOnDeployment;
import org.jboss.arquillian.drone.impl.SecurityActions;
import org.jboss.arquillian.drone.spi.DronePoint;

public class DeploymentDronePointsRegistry {
    private final Map<DronePoint<?>, Object> deploymentDronePoints = new HashMap();
    private Object testClass = null;

    public boolean addDronePoint(DronePoint<?> deploymentDronePoint, Object testClass) {
        if (deploymentDronePoint.getLifecycle() == DronePoint.Lifecycle.DEPLOYMENT) {
            this.deploymentDronePoints.put(deploymentDronePoint, testClass);
            return true;
        }
        return false;
    }

    public Map<DronePoint<?>, Object> filterDeploymentDronePoints(String deploymentName) {
        HashMap matched = new HashMap();
        for (DronePoint<?> dronePoint : this.deploymentDronePoints.keySet()) {
            if (!deploymentName.equals(this.getDeploymentName(dronePoint))) continue;
            matched.put(dronePoint, this.deploymentDronePoints.get(dronePoint));
        }
        return matched;
    }

    private String getDeploymentName(DronePoint<?> dronePoint) {
        Annotation[] annotations = dronePoint.getAnnotations();
        OperateOnDeployment operateOnDeployment = SecurityActions.findAnnotation(annotations, OperateOnDeployment.class);
        return operateOnDeployment.value();
    }
}

