/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.drone.webdriver.configuration;

import java.util.HashMap;
import java.util.Map;
import org.jboss.arquillian.drone.webdriver.configuration.AndroidDriverConfiguration;
import org.jboss.arquillian.drone.webdriver.configuration.ChromeDriverConfiguration;
import org.jboss.arquillian.drone.webdriver.configuration.FirefoxDriverConfiguration;
import org.jboss.arquillian.drone.webdriver.configuration.HtmlUnitDriverConfiguration;
import org.jboss.arquillian.drone.webdriver.configuration.IPhoneDriverConfiguration;
import org.jboss.arquillian.drone.webdriver.configuration.InternetExplorerDriverConfiguration;
import org.jboss.arquillian.drone.webdriver.configuration.OperaDriverConfiguration;
import org.jboss.arquillian.drone.webdriver.configuration.RemoteReusableWebDriverConfiguration;
import org.jboss.arquillian.drone.webdriver.configuration.WebDriverConfigurationType;
import org.openqa.selenium.remote.DesiredCapabilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
enum CapabilityMap {
    ANDROID{

        @Override
        public String getImplementationClass() {
            return "org.openqa.selenium.android.AndroidDriver";
        }

        @Override
        public DesiredCapabilities getCapabilities() {
            return DesiredCapabilities.android();
        }

        @Override
        public String getReadableName() {
            return "android";
        }

        @Override
        public Class<? extends WebDriverConfigurationType> getWebDriverConfigurationType() {
            return AndroidDriverConfiguration.class;
        }
    }
    ,
    CHROME{

        @Override
        public String getImplementationClass() {
            return "org.openqa.selenium.chrome.ChromeDriver";
        }

        @Override
        public DesiredCapabilities getCapabilities() {
            return DesiredCapabilities.chrome();
        }

        @Override
        public String getReadableName() {
            return "chrome";
        }

        @Override
        public Class<? extends WebDriverConfigurationType> getWebDriverConfigurationType() {
            return ChromeDriverConfiguration.class;
        }
    }
    ,
    FIREFOX{

        @Override
        public String getImplementationClass() {
            return "org.openqa.selenium.firefox.FirefoxDriver";
        }

        @Override
        public DesiredCapabilities getCapabilities() {
            return DesiredCapabilities.firefox();
        }

        @Override
        public String getReadableName() {
            return "firefox";
        }

        @Override
        public Class<? extends WebDriverConfigurationType> getWebDriverConfigurationType() {
            return FirefoxDriverConfiguration.class;
        }
    }
    ,
    HTMLUNIT{

        @Override
        public String getImplementationClass() {
            return "org.openqa.selenium.htmlunit.HtmlUnitDriver";
        }

        @Override
        public DesiredCapabilities getCapabilities() {
            return DesiredCapabilities.htmlUnit();
        }

        @Override
        public String getReadableName() {
            return "htmlUnit";
        }

        @Override
        public Class<? extends WebDriverConfigurationType> getWebDriverConfigurationType() {
            return HtmlUnitDriverConfiguration.class;
        }
    }
    ,
    INTERNETEXPLORER{

        @Override
        public String getImplementationClass() {
            return "org.openqa.selenium.ie.InternetExplorerDriver";
        }

        @Override
        public DesiredCapabilities getCapabilities() {
            return DesiredCapabilities.internetExplorer();
        }

        @Override
        public String getReadableName() {
            return "internetExplorer";
        }

        @Override
        public Class<? extends WebDriverConfigurationType> getWebDriverConfigurationType() {
            return InternetExplorerDriverConfiguration.class;
        }
    }
    ,
    IPHONE{

        @Override
        public String getImplementationClass() {
            return "org.openqa.selenium.iphone.IPhoneDriver";
        }

        @Override
        public DesiredCapabilities getCapabilities() {
            return DesiredCapabilities.iphone();
        }

        @Override
        public String getReadableName() {
            return "iphone";
        }

        @Override
        public Class<? extends WebDriverConfigurationType> getWebDriverConfigurationType() {
            return IPhoneDriverConfiguration.class;
        }
    }
    ,
    OPERA{

        @Override
        public String getImplementationClass() {
            return "com.opera.core.systems.OperaDriver";
        }

        @Override
        public DesiredCapabilities getCapabilities() {
            return DesiredCapabilities.opera();
        }

        @Override
        public String getReadableName() {
            return "opera";
        }

        @Override
        public Class<? extends WebDriverConfigurationType> getWebDriverConfigurationType() {
            return OperaDriverConfiguration.class;
        }
    }
    ,
    REMOTE{

        @Override
        public String getReadableName() {
            return null;
        }

        @Override
        public String getImplementationClass() {
            return "org.openqa.selenium.remote.RemoteWebDriver";
        }

        @Override
        public DesiredCapabilities getCapabilities() {
            return null;
        }

        @Override
        public Class<? extends WebDriverConfigurationType> getWebDriverConfigurationType() {
            return RemoteReusableWebDriverConfiguration.class;
        }
    };

    private static final Map<String, CapabilityMap> IMPLEMENTATION_CLASS_CACHE;
    private static final Map<Class<? extends WebDriverConfigurationType>, CapabilityMap> CONFIGURATION_TYPE_CACHE;

    public abstract String getReadableName();

    public abstract String getImplementationClass();

    public abstract DesiredCapabilities getCapabilities();

    public abstract Class<? extends WebDriverConfigurationType> getWebDriverConfigurationType();

    public static CapabilityMap byDesiredCapabilities(String capabilities) {
        if (capabilities == null || capabilities.length() == 0) {
            return null;
        }
        try {
            return CapabilityMap.valueOf(CapabilityMap.class, capabilities.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            StringBuilder sb = new StringBuilder();
            for (CapabilityMap map : CapabilityMap.values()) {
                sb.append(map.getReadableName()).append(" ");
            }
            throw new IllegalArgumentException("Capabilities \"" + capabilities + "\" are not supported. The list of supported browser via capabilities is: " + sb.toString());
        }
    }

    public static CapabilityMap byImplementationClass(String implementationClass) {
        if (implementationClass == null || implementationClass.length() == 0) {
            return null;
        }
        return IMPLEMENTATION_CLASS_CACHE.get(implementationClass);
    }

    public static CapabilityMap byWebDriverConfigurationType(Class<? extends WebDriverConfigurationType> configurationType) {
        if (configurationType == null) {
            return null;
        }
        return CONFIGURATION_TYPE_CACHE.get(configurationType);
    }

    static {
        IMPLEMENTATION_CLASS_CACHE = new HashMap<String, CapabilityMap>(){
            private static final long serialVersionUID = 1L;
            {
                for (CapabilityMap map : CapabilityMap.values()) {
                    this.put(map.getImplementationClass(), map);
                }
            }
        };
        CONFIGURATION_TYPE_CACHE = new HashMap<Class<? extends WebDriverConfigurationType>, CapabilityMap>(){
            private static final long serialVersionUID = 1L;
            {
                for (CapabilityMap map : CapabilityMap.values()) {
                    this.put(map.getWebDriverConfigurationType(), map);
                }
            }
        };
    }
}

