/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.drone.webdriver.factory;

import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.arquillian.config.descriptor.api.ArquillianDescriptor;
import org.jboss.arquillian.drone.spi.Configurator;
import org.jboss.arquillian.drone.spi.Destructor;
import org.jboss.arquillian.drone.spi.DroneConfiguration;
import org.jboss.arquillian.drone.spi.Instantiator;
import org.jboss.arquillian.drone.webdriver.configuration.IPhoneDriverConfiguration;
import org.jboss.arquillian.drone.webdriver.configuration.TypedWebDriverConfiguration;
import org.jboss.arquillian.drone.webdriver.factory.SecurityActions;
import org.jboss.arquillian.drone.webdriver.factory.Validate;
import org.openqa.selenium.iphone.IPhoneDriver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IPhoneDriverFactory
implements Configurator<IPhoneDriver, TypedWebDriverConfiguration<IPhoneDriverConfiguration>>,
Instantiator<IPhoneDriver, TypedWebDriverConfiguration<IPhoneDriverConfiguration>>,
Destructor<IPhoneDriver> {
    private static final Logger log = Logger.getLogger(IPhoneDriverFactory.class.getName());

    public int getPrecedence() {
        return 0;
    }

    public void destroyInstance(IPhoneDriver instance) {
        instance.quit();
    }

    public IPhoneDriver createInstance(TypedWebDriverConfiguration<IPhoneDriverConfiguration> configuration) {
        URL remoteAddress = configuration.getRemoteAddress();
        if (Validate.empty(remoteAddress)) {
            remoteAddress = TypedWebDriverConfiguration.DEFAULT_REMOTE_URL;
            log.log(Level.INFO, "Property \"remoteAdress\" was not specified, using default value of {0}", TypedWebDriverConfiguration.DEFAULT_REMOTE_URL);
        }
        Validate.isValidUrl(remoteAddress, "Remote address must be a valid url, " + remoteAddress);
        return SecurityActions.newInstance(configuration.getImplementationClass(), new Class[]{URL.class}, new Object[]{remoteAddress}, IPhoneDriver.class);
    }

    public TypedWebDriverConfiguration<IPhoneDriverConfiguration> createConfiguration(ArquillianDescriptor descriptor, Class<? extends Annotation> qualifier) {
        DroneConfiguration configuration = new TypedWebDriverConfiguration<IPhoneDriverConfiguration>(IPhoneDriverConfiguration.class).configure(descriptor, qualifier);
        if (!configuration.isRemote()) {
            configuration.setRemote(true);
            log.log(Level.FINE, "Forcing IPhoneDriver configuration to be remote-based.");
        }
        return configuration;
    }
}

