/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.drone.webdriver.factory;

import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.arquillian.config.descriptor.api.ArquillianDescriptor;
import org.jboss.arquillian.core.api.Event;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.drone.spi.Configurator;
import org.jboss.arquillian.drone.spi.Destructor;
import org.jboss.arquillian.drone.spi.DroneConfiguration;
import org.jboss.arquillian.drone.spi.Instantiator;
import org.jboss.arquillian.drone.webdriver.configuration.RemoteReusableWebDriverConfiguration;
import org.jboss.arquillian.drone.webdriver.configuration.TypedWebDriverConfiguration;
import org.jboss.arquillian.drone.webdriver.factory.Validate;
import org.jboss.arquillian.drone.webdriver.factory.remote.reusable.InitializationParameter;
import org.jboss.arquillian.drone.webdriver.factory.remote.reusable.InitializationParametersMap;
import org.jboss.arquillian.drone.webdriver.factory.remote.reusable.PersistReusedSessionsEvent;
import org.jboss.arquillian.drone.webdriver.factory.remote.reusable.ReusableRemoteWebDriver;
import org.jboss.arquillian.drone.webdriver.factory.remote.reusable.ReusedSession;
import org.jboss.arquillian.drone.webdriver.factory.remote.reusable.ReusedSessionStore;
import org.jboss.arquillian.drone.webdriver.factory.remote.reusable.UnableReuseSessionException;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.SessionId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteWebDriverFactory
implements Configurator<RemoteWebDriver, TypedWebDriverConfiguration<RemoteReusableWebDriverConfiguration>>,
Instantiator<RemoteWebDriver, TypedWebDriverConfiguration<RemoteReusableWebDriverConfiguration>>,
Destructor<RemoteWebDriver> {
    private static final Logger log = Logger.getLogger(RemoteWebDriverFactory.class.getName());
    @Inject
    Instance<ReusedSessionStore> sessionStore;
    @Inject
    Instance<InitializationParametersMap> initParams;
    @Inject
    Event<PersistReusedSessionsEvent> persistEvent;

    public int getPrecedence() {
        return 0;
    }

    public RemoteWebDriver createInstance(TypedWebDriverConfiguration<RemoteReusableWebDriverConfiguration> configuration) {
        URL remoteAddress = configuration.getRemoteAddress();
        if (Validate.empty(remoteAddress)) {
            remoteAddress = TypedWebDriverConfiguration.DEFAULT_REMOTE_URL;
            log.log(Level.INFO, "Property \"remoteAdress\" was not specified, using default value of {0}", TypedWebDriverConfiguration.DEFAULT_REMOTE_URL);
        }
        Validate.isValidUrl(remoteAddress, "Remote address must be a valid url, " + remoteAddress);
        String browserCapabilities = configuration.getBrowserCapabilities();
        if (Validate.empty(browserCapabilities)) {
            configuration.setBrowserCapabilities(TypedWebDriverConfiguration.DEFAULT_BROWSER_CAPABILITIES);
            log.log(Level.INFO, "Property \"browserCapabilities\" was not specified, using default value of {0}", TypedWebDriverConfiguration.DEFAULT_BROWSER_CAPABILITIES);
        }
        Validate.isEmpty(configuration.getBrowserCapabilities(), "The browser capabilities are not set.");
        Capabilities desiredCapabilities = configuration.getCapabilities();
        if (configuration.isRemoteReusable()) {
            return this.createReusableDriver(remoteAddress, desiredCapabilities);
        }
        return this.createRemoteDriver(remoteAddress, desiredCapabilities);
    }

    public void destroyInstance(RemoteWebDriver instance) {
        if (instance.getSessionId() == null) {
            log.warning("The driver has been already destroyed and can't be destroyed again.");
            return;
        }
        InitializationParameter param = (InitializationParameter)((InitializationParametersMap)this.initParams.get()).remove(instance.getSessionId());
        if (param != null) {
            ReusedSession session = new ReusedSession(instance.getSessionId(), instance.getCapabilities());
            ((ReusedSessionStore)this.sessionStore.get()).store(param, session);
            this.persistEvent.fire((Object)new PersistReusedSessionsEvent());
        } else {
            instance.quit();
        }
    }

    public TypedWebDriverConfiguration<RemoteReusableWebDriverConfiguration> createConfiguration(ArquillianDescriptor descriptor, Class<? extends Annotation> qualifier) {
        DroneConfiguration configuration = new TypedWebDriverConfiguration<RemoteReusableWebDriverConfiguration>(RemoteReusableWebDriverConfiguration.class).configure(descriptor, qualifier);
        if (!configuration.isRemote()) {
            configuration.setRemote(true);
            log.log(Level.FINE, "Forcing RemoteWebDriver configuration to be remote-based.");
        }
        return configuration;
    }

    protected RemoteWebDriver createRemoteDriver(URL remoteAddress, Capabilities desiredCapabilities) {
        return new RemoteWebDriver(remoteAddress, desiredCapabilities);
    }

    private ReusableRemoteWebDriver createReusableDriver(URL remoteAddress, Capabilities desiredCapabilities) {
        InitializationParameter initParam = new InitializationParameter(remoteAddress, desiredCapabilities);
        ReusableRemoteWebDriver driver = null;
        ReusedSession stored = ((ReusedSessionStore)this.sessionStore.get()).pull(initParam);
        while (stored != null) {
            SessionId reusedSessionId = stored.getSessionId();
            try {
                driver = ReusableRemoteWebDriver.fromReusedSession(remoteAddress, desiredCapabilities, reusedSessionId);
                break;
            }
            catch (UnableReuseSessionException ex) {
                log.log(Level.WARNING, "Unable to reuse session: {0}", stored.getSessionId());
                stored = ((ReusedSessionStore)this.sessionStore.get()).pull(initParam);
            }
        }
        if (driver == null) {
            RemoteWebDriver newdriver = this.createRemoteDriver(remoteAddress, desiredCapabilities);
            driver = ReusableRemoteWebDriver.fromRemoteWebDriver(newdriver);
        }
        ((InitializationParametersMap)this.initParams.get()).put(driver.getSessionId(), initParam);
        return driver;
    }
}

