/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.drone.webdriver.factory;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Logger;

class Validate {
    private static final FileExecutableChecker fileExecutableChecker = new FileExecutableChecker();

    Validate() {
    }

    static boolean empty(Object object) {
        return object == null;
    }

    static boolean empty(String object) {
        return object == null || object.length() == 0;
    }

    static boolean nonEmpty(String object) {
        return !Validate.empty(object);
    }

    static void isEmpty(String object, String message) throws IllegalArgumentException {
        if (Validate.empty(object)) {
            throw new IllegalArgumentException(message);
        }
    }

    static void isValidPath(String path, String message) throws IllegalArgumentException {
        Validate.isEmpty(path, message);
        File file = new File(path);
        if (!file.exists() || !file.canRead()) {
            throw new IllegalArgumentException(message);
        }
    }

    static void isValidUrl(URL url, String message) throws IllegalArgumentException {
        if (url == null) {
            throw new IllegalArgumentException(message);
        }
    }

    static void isValidUrl(String url, String message) throws IllegalArgumentException {
        Validate.isEmpty(url, message);
        try {
            new URL(url);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(message, e);
        }
    }

    static void isExecutable(String path, String message) throws IllegalArgumentException {
        Validate.isEmpty(path, message);
        File file = new File(path);
        if (!file.exists() || !fileExecutableChecker.canExecute(file)) {
            throw new IllegalArgumentException(message);
        }
    }

    private static final class FileExecutableChecker {
        private static final Logger log = Logger.getLogger(FileExecutableChecker.class.getName());
        private final Method isExecutableMethod;

        FileExecutableChecker() {
            Method m = null;
            try {
                m = File.class.getMethod("canExecute", new Class[0]);
            }
            catch (SecurityException e) {
                log.warning("Unable to verify executable bits for files, will consider them all executable. " + e.getMessage());
            }
            catch (NoSuchMethodException e) {
                log.warning("Unable to verify executable bits for files, will consider them all executable. " + e.getMessage());
            }
            this.isExecutableMethod = m;
        }

        public boolean canExecute(File file) {
            if (this.isExecutableMethod == null) {
                return true;
            }
            Boolean result = true;
            try {
                result = (Boolean)this.isExecutableMethod.invoke((Object)file, new Object[0]);
            }
            catch (IllegalArgumentException e) {
                log.warning("Unable to check if " + file.getAbsolutePath() + " can be executed, will consider it executable." + e.getMessage());
            }
            catch (IllegalAccessException e) {
                log.warning("Unable to check if " + file.getAbsolutePath() + " can be executed, will consider it executable." + e.getMessage());
            }
            catch (InvocationTargetException e) {
                log.warning("Unable to check if " + file.getAbsolutePath() + " can be executed, will consider it executable." + e.getMessage());
            }
            return result;
        }
    }
}

