/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.drone.webdriver.factory;

import java.lang.annotation.Annotation;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.arquillian.config.descriptor.api.ArquillianDescriptor;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.drone.spi.Configurator;
import org.jboss.arquillian.drone.spi.Destructor;
import org.jboss.arquillian.drone.spi.DroneRegistry;
import org.jboss.arquillian.drone.spi.Instantiator;
import org.jboss.arquillian.drone.webdriver.configuration.TypedWebDriverConfiguration;
import org.jboss.arquillian.drone.webdriver.configuration.WebDriverConfiguration;
import org.jboss.arquillian.drone.webdriver.factory.SecurityActions;
import org.jboss.arquillian.drone.webdriver.factory.Validate;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.RemoteWebDriver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebDriverFactory
implements Configurator<WebDriver, TypedWebDriverConfiguration<WebDriverConfiguration>>,
Instantiator<WebDriver, TypedWebDriverConfiguration<WebDriverConfiguration>>,
Destructor<WebDriver> {
    private static final Logger log = Logger.getLogger(WebDriverFactory.class.getName());
    @Inject
    private Instance<DroneRegistry> registryInstance;

    public int getPrecedence() {
        return 0;
    }

    public void destroyInstance(WebDriver instance) {
        Class instanceClass = instance instanceof RemoteWebDriver ? RemoteWebDriver.class : instance.getClass();
        Object destructor = null;
        try {
            destructor = (Destructor)((DroneRegistry)this.registryInstance.get()).getEntryFor(instanceClass, Destructor.class);
        }
        catch (Exception ignored) {
            // empty catch block
        }
        if (destructor != null && !destructor.getClass().equals(this.getClass())) {
            destructor.destroyInstance((Object)instance);
        } else {
            instance.quit();
        }
    }

    public WebDriver createInstance(TypedWebDriverConfiguration<WebDriverConfiguration> configuration) {
        Instantiator instantiator;
        String implementationClassName = null;
        if (configuration.isRemoteReusable() || configuration.isRemote()) {
            instantiator = this.getRemoteWebDriverInstantiator();
        } else {
            String browserCapabilities = configuration.getBrowserCapabilities();
            if (Validate.empty(browserCapabilities)) {
                configuration.setBrowserCapabilities(TypedWebDriverConfiguration.DEFAULT_BROWSER_CAPABILITIES);
                log.log(Level.INFO, "Property \"browserCapabilities\" was not specified, using default value of {0}", TypedWebDriverConfiguration.DEFAULT_BROWSER_CAPABILITIES);
            }
            implementationClassName = configuration.getImplementationClass();
            Validate.isEmpty(implementationClassName, "The combination of browserCapabilities=" + configuration.getBrowserCapabilities() + ", implemenationClass=" + implementationClassName + " does not to a valid browser. Please specify supported browserCapabilities");
            DroneRegistry registry = (DroneRegistry)this.registryInstance.get();
            Class<?> implementationClass = SecurityActions.getClass(implementationClassName);
            instantiator = (Instantiator)registry.getEntryFor(implementationClass, Instantiator.class);
        }
        if (instantiator != null && instantiator.getClass() != this.getClass()) {
            return (WebDriver)instantiator.createInstance(configuration);
        }
        if (Validate.empty(implementationClassName)) {
            WebDriver driver = SecurityActions.newInstance(implementationClassName, new Class[0], new Object[0], WebDriver.class);
            return driver;
        }
        throw new IllegalStateException("Unable to create Arquillian WebDriver browser, please set \"browserCapabilites\" or \"implementationClass\" property");
    }

    public TypedWebDriverConfiguration<WebDriverConfiguration> createConfiguration(ArquillianDescriptor descriptor, Class<? extends Annotation> qualifier) {
        return new TypedWebDriverConfiguration<WebDriverConfiguration>(WebDriverConfiguration.class).configure(descriptor, qualifier);
    }

    private Instantiator getRemoteWebDriverInstantiator() {
        DroneRegistry registry = (DroneRegistry)this.registryInstance.get();
        return (Instantiator)registry.getEntryFor(RemoteWebDriver.class, Instantiator.class);
    }
}

