/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.drone.webdriver.factory;

import java.io.OutputStream;
import org.jboss.arquillian.drone.spi.Configurator;
import org.jboss.arquillian.drone.spi.Destructor;
import org.jboss.arquillian.drone.spi.Instantiator;
import org.jboss.arquillian.drone.webdriver.configuration.WebDriverConfiguration;
import org.jboss.arquillian.drone.webdriver.factory.AbstractWebDriverFactory;
import org.jboss.arquillian.drone.webdriver.factory.BrowserCapabilitiesList;
import org.jboss.arquillian.drone.webdriver.factory.CapabilitiesOptionsMapper;
import org.jboss.arquillian.drone.webdriver.factory.SecurityActions;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.remote.service.DriverService;
import org.openqa.selenium.safari.SafariDriver;
import org.openqa.selenium.safari.SafariDriverService;
import org.openqa.selenium.safari.SafariOptions;

public class SafariDriverFactory
extends AbstractWebDriverFactory<SafariDriver>
implements Configurator<SafariDriver, WebDriverConfiguration>,
Instantiator<SafariDriver, WebDriverConfiguration>,
Destructor<SafariDriver> {
    private static final String BROWSER_CAPABILITIES = new BrowserCapabilitiesList.Safari().getReadableName();

    public int getPrecedence() {
        return 0;
    }

    public void destroyInstance(SafariDriver instance) {
        instance.quit();
    }

    public SafariDriver createInstance(WebDriverConfiguration configuration) {
        SafariDriverService service = (SafariDriverService)((SafariDriverService.Builder)new SafariDriverService.Builder().withLogOutput((OutputStream)System.out)).build();
        SafariOptions options = this.getOptions(configuration, true);
        return SecurityActions.newInstance(configuration.getImplementationClass(), new Class[]{DriverService.class, SafariOptions.class}, new Object[]{service, options}, SafariDriver.class);
    }

    public SafariOptions getOptions(WebDriverConfiguration configuration, boolean performValidations) {
        Capabilities capabilities = configuration.getCapabilities();
        SafariOptions safariOptions = new SafariOptions();
        CapabilitiesOptionsMapper.mapCapabilities(safariOptions, capabilities, BROWSER_CAPABILITIES);
        return safariOptions;
    }

    @Override
    protected String getDriverReadableName() {
        return BROWSER_CAPABILITIES;
    }
}

