/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.extension.byteman.impl.container;

import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.extension.byteman.impl.common.BytemanConfiguration;
import org.jboss.arquillian.extension.byteman.impl.common.ExtractScriptUtil;
import org.jboss.arquillian.extension.byteman.impl.common.SubmitUtil;
import org.jboss.arquillian.test.spi.event.suite.After;
import org.jboss.arquillian.test.spi.event.suite.AfterClass;
import org.jboss.arquillian.test.spi.event.suite.Before;
import org.jboss.arquillian.test.spi.event.suite.BeforeClass;
import org.jboss.arquillian.test.spi.event.suite.ClassLifecycleEvent;
import org.jboss.arquillian.test.spi.event.suite.TestLifecycleEvent;

public class RuleInstaller {
    public static final String CLASS_KEY_PREFIX = "Class:";
    public static final String METHOD_KEY_PREFIX = "Method:";

    public void installClass(@Observes BeforeClass event) {
        BytemanConfiguration config = BytemanConfiguration.from(Thread.currentThread().getContextClassLoader().getResourceAsStream(BytemanConfiguration.BYTEMAN_CONFIG));
        String script = ExtractScriptUtil.extract((ClassLifecycleEvent)event);
        if (script != null) {
            SubmitUtil.install(this.generateKey(CLASS_KEY_PREFIX), script, config.containerAgentPort());
        }
    }

    public void uninstallClass(@Observes AfterClass event) {
        BytemanConfiguration config = BytemanConfiguration.from(Thread.currentThread().getContextClassLoader().getResourceAsStream(BytemanConfiguration.BYTEMAN_CONFIG));
        String script = ExtractScriptUtil.extract((ClassLifecycleEvent)event);
        if (script != null) {
            SubmitUtil.uninstall(this.generateKey(CLASS_KEY_PREFIX), script, config.containerAgentPort());
        }
    }

    public void installMethod(@Observes Before event) {
        BytemanConfiguration config = BytemanConfiguration.from(Thread.currentThread().getContextClassLoader().getResourceAsStream(BytemanConfiguration.BYTEMAN_CONFIG));
        String script = ExtractScriptUtil.extract((TestLifecycleEvent)event);
        if (script != null) {
            SubmitUtil.install(this.generateKey(METHOD_KEY_PREFIX), script, config.containerAgentPort());
        }
    }

    public void uninstallMethod(@Observes After event) {
        BytemanConfiguration config = BytemanConfiguration.from(Thread.currentThread().getContextClassLoader().getResourceAsStream(BytemanConfiguration.BYTEMAN_CONFIG));
        String script = ExtractScriptUtil.extract((TestLifecycleEvent)event);
        if (script != null) {
            SubmitUtil.uninstall(this.generateKey(METHOD_KEY_PREFIX), script, config.containerAgentPort());
        }
    }

    private String generateKey(String prefix) {
        return prefix + Thread.currentThread().getName();
    }
}

