/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.extension.byteman.impl.container;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.extension.byteman.agent.submit.ScriptText;
import org.jboss.arquillian.extension.byteman.agent.submit.Submit;
import org.jboss.arquillian.extension.byteman.impl.common.BytemanConfiguration;
import org.jboss.arquillian.extension.byteman.impl.common.GenerateScriptUtil;
import org.jboss.arquillian.extension.byteman.impl.common.SubmitException;
import org.jboss.arquillian.test.spi.event.suite.AfterSuite;
import org.jboss.arquillian.test.spi.event.suite.BeforeSuite;

public class ScriptInstaller {
    public void install(@Observes BeforeSuite event) {
        block4: {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            InputStream scriptStream = cl.getResourceAsStream(BytemanConfiguration.BYTEMAN_SCRIPT);
            try {
                if (scriptStream == null || scriptStream.available() <= 0) break block4;
                BytemanConfiguration config = BytemanConfiguration.from(Thread.currentThread().getContextClassLoader().getResourceAsStream(BytemanConfiguration.BYTEMAN_CONFIG));
                String ruleKey = Thread.currentThread().getName();
                String ruleScript = GenerateScriptUtil.toString(scriptStream);
                try {
                    Submit submit = new Submit("localhost", config.containerAgentPort());
                    submit.addScripts(Arrays.asList(new ScriptText(ruleKey, ruleScript)));
                }
                catch (Exception e) {
                    throw new SubmitException("Could not install script from file", e);
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Could not check stream", e);
            }
        }
    }

    public void uninstall(@Observes AfterSuite event) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        InputStream scriptStream = cl.getResourceAsStream(BytemanConfiguration.BYTEMAN_SCRIPT);
        if (scriptStream != null) {
            BytemanConfiguration config = BytemanConfiguration.from(Thread.currentThread().getContextClassLoader().getResourceAsStream(BytemanConfiguration.BYTEMAN_CONFIG));
            String ruleKey = Thread.currentThread().getName();
            String ruleScript = GenerateScriptUtil.toString(scriptStream);
            try {
                Submit submit = new Submit("localhost", config.containerAgentPort());
                submit.deleteScripts(Arrays.asList(new ScriptText(ruleKey, ruleScript)));
            }
            catch (Exception e) {
                throw new SubmitException("Could not uninstall script from file", e);
            }
        }
    }
}

