/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.phantom.resolver.maven;

import java.io.File;
import java.io.IOException;
import java.util.zip.ZipFile;
import org.jboss.arquillian.phantom.resolver.FileUtils;
import org.jboss.arquillian.phantom.resolver.PhantomJSBinary;
import org.jboss.arquillian.phantom.resolver.PhantomJSBinaryResolver;
import org.jboss.arquillian.phantom.resolver.ResolverConfiguration;
import org.jboss.arquillian.phantom.resolver.maven.PlatformUtils;
import org.jboss.shrinkwrap.resolver.api.maven.Maven;
import org.jboss.shrinkwrap.resolver.api.maven.MavenFormatStage;
import org.jboss.shrinkwrap.resolver.api.maven.MavenStrategyStage;

public class MavenPhantomJSBinaryResolver
implements PhantomJSBinaryResolver {
    public static final String PHANTOMJS = "phantomjs" + (PlatformUtils.isWindows() ? ".exe" : "");
    public static final String PHANTOMJS_RESOURCE = (PlatformUtils.isWindows() ? "" : "bin/") + PHANTOMJS;
    protected static final String ARTIFACT_BINARY = "org.jboss.arquillian.extension:arquillian-phantom-binary:jar";

    @Override
    public PhantomJSBinary resolve(File destination) throws IOException {
        File realDestination;
        File file = realDestination = destination.isDirectory() ? new File(destination, PHANTOMJS) : destination;
        if (realDestination.exists() && realDestination.length() > 0L && realDestination.canExecute()) {
            return new PhantomJSBinary(realDestination);
        }
        return this.resolveFreshExtracted(realDestination);
    }

    protected PhantomJSBinary resolveFreshExtracted(File destination) throws IOException {
        if (destination.exists()) {
            destination.delete();
        }
        if (!destination.getParentFile().exists()) {
            destination.getParentFile().mkdirs();
        }
        ZipFile jar = new ZipFile(this.getJavaArchive());
        FileUtils.extract(jar, PHANTOMJS_RESOURCE, destination);
        return new PhantomJSBinary(destination);
    }

    protected File getJavaArchive() {
        String version = ResolverConfiguration.get().version();
        String gav = this.getArtifactCanonicalForm(version);
        return ((MavenFormatStage)((MavenStrategyStage)Maven.resolver().resolve(gav)).withoutTransitivity()).asSingleFile();
    }

    protected String getArtifactCanonicalForm(String version) {
        switch (PlatformUtils.platform().os()) {
            case WINDOWS: {
                return "org.jboss.arquillian.extension:arquillian-phantom-binary:jar:windows:" + version;
            }
            case UNIX: {
                if (PlatformUtils.is64()) {
                    return "org.jboss.arquillian.extension:arquillian-phantom-binary:jar:linux-64:" + version;
                }
                return "org.jboss.arquillian.extension:arquillian-phantom-binary:jar:linux-32:" + version;
            }
            case MACOSX: {
                return "org.jboss.arquillian.extension:arquillian-phantom-binary:jar:macosx:" + version;
            }
        }
        throw new IllegalStateException("The current platform is not supported.Supported platforms are windows, linux and macosx.Your platform has been detected as " + PlatformUtils.platform().os().toString().toLowerCase() + "" + "from the the system property 'os.name' => '" + PlatformUtils.OS + "'.");
    }
}

