/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.portal.impl.container;

import java.util.ArrayList;
import java.util.Collection;
import org.jboss.arquillian.container.spi.client.container.DeploymentException;
import org.jboss.arquillian.container.spi.event.container.AfterStart;
import org.jboss.arquillian.container.spi.event.container.BeforeStop;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.core.spi.ServiceLoader;
import org.jboss.arquillian.portal.spi.container.deployment.PortletContainerDeploymentProvider;
import org.jboss.shrinkwrap.api.Archive;

public class PortalAdditionalDeployments {
    @Inject
    Instance<ServiceLoader> loader;
    Collection<Archive<?>> deployments = new ArrayList();

    public void deployPortal(@Observes AfterStart afterStartEvent) throws DeploymentException {
        Collection providers = ((ServiceLoader)this.loader.get()).all(PortletContainerDeploymentProvider.class);
        for (PortletContainerDeploymentProvider provider : providers) {
            Archive tmp = provider.build();
            this.deployments.add(tmp);
            afterStartEvent.getDeployableContainer().deploy(tmp);
            tmp = null;
        }
    }

    public void undeployPortal(@Observes BeforeStop beforeStopEvent) throws DeploymentException {
        for (Archive<?> archive : this.deployments) {
            beforeStopEvent.getDeployableContainer().undeploy(archive);
        }
    }
}

