/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.portal.impl.deployment;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import org.jboss.arquillian.container.spi.context.annotation.DeploymentScoped;
import org.jboss.arquillian.container.spi.event.container.BeforeDeploy;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.InstanceProducer;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.portal.api.PortalURL;
import org.jboss.arquillian.portal.impl.PortletArchiveMetadata;
import org.jboss.arquillian.test.spi.TestClass;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.descriptor.api.Descriptors;
import org.jboss.shrinkwrap.descriptor.api.portletapp20.PortletDescriptor;
import org.jboss.shrinkwrap.descriptor.api.portletapp20.PortletType;

public class PortletXMLProcessor {
    @Inject
    Instance<TestClass> testClassInstance;
    @Inject
    @DeploymentScoped
    InstanceProducer<PortletArchiveMetadata> portletMetadata;

    public void parsePortletXml(@Observes BeforeDeploy event) {
        Field field;
        boolean processed = false;
        Archive applicationArchive = event.getDeployment().getArchive();
        TestClass testClass = (TestClass)this.testClassInstance.get();
        AccessibleObject[] arr$ = testClass.getJavaClass().getDeclaredFields();
        int len$ = arr$.length;
        for (int i$ = 0; !(i$ >= len$ || (field = arr$[i$]).isAnnotationPresent(PortalURL.class) && (processed = this.processPortletXml(applicationArchive))); ++i$) {
        }
        if (!processed) {
            for (AccessibleObject accessibleObject : testClass.getJavaClass().getDeclaredMethods()) {
                Annotation[][] methodParameterAnnotations;
                Annotation[][] arr$2 = methodParameterAnnotations = ((Method)accessibleObject).getParameterAnnotations();
                int len$2 = arr$2.length;
                for (int i$ = 0; i$ < len$2; ++i$) {
                    Annotation annotation;
                    Annotation[] parameterAnnotations;
                    Annotation[] arr$3 = parameterAnnotations = arr$2[i$];
                    int len$3 = arr$3.length;
                    for (int i$2 = 0; !(i$2 >= len$3 || (annotation = arr$3[i$2]) instanceof PortalURL && (processed = this.processPortletXml(applicationArchive))); ++i$2) {
                    }
                }
            }
        }
    }

    private boolean processPortletXml(Archive<?> applicationArchive) {
        try {
            PortletDescriptor portletXml = (PortletDescriptor)Descriptors.importAs(PortletDescriptor.class).fromStream(applicationArchive.get("WEB-INF/portlet.xml").getAsset().openStream());
            if (null != portletXml) {
                PortletArchiveMetadata metadata = new PortletArchiveMetadata();
                List portlets = portletXml.getAllPortlet();
                for (PortletType portlet : portlets) {
                    metadata.addPortletName(portlet.getPortletName());
                }
                this.portletMetadata.set((Object)metadata);
            }
            return true;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to retrieve portlet.xml from Deployment", e);
        }
    }
}

