/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.warp;

import java.util.Collection;
import org.jboss.arquillian.container.test.spi.RemoteLoadableExtension;
import org.jboss.arquillian.container.test.spi.client.deployment.ApplicationArchiveProcessor;
import org.jboss.arquillian.container.test.spi.client.deployment.AuxiliaryArchiveAppender;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.spi.ServiceLoader;
import org.jboss.arquillian.test.spi.TestClass;
import org.jboss.arquillian.warp.ServerAssertion;
import org.jboss.arquillian.warp.WarpRemoteExtension;
import org.jboss.arquillian.warp.WarpTest;
import org.jboss.arquillian.warp.extension.servlet.BeforeServletEvent;
import org.jboss.arquillian.warp.server.assertion.AssertionRegistry;
import org.jboss.arquillian.warp.server.enrich.HttpServletRequestEnricher;
import org.jboss.arquillian.warp.server.filter.WarpFilter;
import org.jboss.arquillian.warp.server.lifecycle.LifecycleManagerImpl;
import org.jboss.arquillian.warp.server.request.RequestContext;
import org.jboss.arquillian.warp.server.test.LifecycleTestDriver;
import org.jboss.arquillian.warp.shared.ResponsePayload;
import org.jboss.arquillian.warp.spi.LifecycleEvent;
import org.jboss.arquillian.warp.spi.WarpLifecycleExtension;
import org.jboss.arquillian.warp.utils.Base64;
import org.jboss.arquillian.warp.utils.BaseNCodec;
import org.jboss.arquillian.warp.utils.SerializationUtils;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeploymentEnricher
implements ApplicationArchiveProcessor,
AuxiliaryArchiveAppender {
    @Inject
    private Instance<ServiceLoader> serviceLoader;
    @Inject
    Instance<TestClass> testClass;

    public void process(Archive<?> applicationArchive, TestClass testClass) {
        if (testClass.isAnnotationPresent(WarpTest.class) && applicationArchive instanceof WebArchive) {
            WebArchive webArchive = (WebArchive)applicationArchive;
            Collection lifecycleExtensions = ((ServiceLoader)this.serviceLoader.get()).all(WarpLifecycleExtension.class);
            for (WarpLifecycleExtension extension : lifecycleExtensions) {
                JavaArchive library = extension.getEnrichmentLibrary();
                if (library != null) {
                    webArchive.addAsLibrary((Archive)library);
                }
                extension.enrichWebArchive(webArchive);
            }
        }
    }

    public Archive<?> createAuxiliaryArchive() {
        TestClass testClass = (TestClass)this.testClass.get();
        if (testClass.isAnnotationPresent(WarpTest.class)) {
            JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"extension-warp.jar");
            archive.addPackage(WarpFilter.class.getPackage());
            archive.addPackage(WarpRemoteExtension.class.getPackage());
            archive.addPackage(LifecycleManagerImpl.class.getPackage());
            archive.addPackage(RequestContext.class.getPackage());
            archive.addPackage(LifecycleTestDriver.class.getPackage());
            archive.addPackage(AssertionRegistry.class.getPackage());
            archive.addPackage(LifecycleEvent.class.getPackage());
            archive.addPackage(BeforeServletEvent.class.getPackage());
            archive.addPackage(ResponsePayload.class.getPackage());
            archive.addPackage(HttpServletRequestEnricher.class.getPackage());
            archive.addClass(ServerAssertion.class);
            archive.addClasses(new Class[]{SerializationUtils.class, Base64.class, BaseNCodec.class});
            archive.addAsServiceProvider(RemoteLoadableExtension.class, new Class[]{WarpRemoteExtension.class});
            return archive;
        }
        return null;
    }
}

