/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.warp.server.filter;

import java.lang.reflect.InvocationTargetException;
import javax.servlet.ServletRequest;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.spi.Manager;
import org.jboss.arquillian.test.spi.TestResult;
import org.jboss.arquillian.test.spi.event.suite.AfterSuite;
import org.jboss.arquillian.test.spi.event.suite.BeforeSuite;
import org.jboss.arquillian.warp.ServerAssertion;
import org.jboss.arquillian.warp.extension.servlet.AfterServletEvent;
import org.jboss.arquillian.warp.extension.servlet.BeforeServletEvent;
import org.jboss.arquillian.warp.server.assertion.AssertionRegistry;
import org.jboss.arquillian.warp.server.filter.DoFilterCommand;
import org.jboss.arquillian.warp.server.lifecycle.LifecycleManagerImpl;
import org.jboss.arquillian.warp.server.lifecycle.LifecycleManagerStoreImpl;
import org.jboss.arquillian.warp.server.request.AfterRequest;
import org.jboss.arquillian.warp.server.request.BeforeRequest;
import org.jboss.arquillian.warp.server.test.TestResultStore;
import org.jboss.arquillian.warp.shared.ResponsePayload;

public class WarpLifecycle {
    @Inject
    private Instance<LifecycleManagerImpl> lifecycleManager;
    @Inject
    private Instance<LifecycleManagerStoreImpl> lifecycleManagerStore;
    @Inject
    private Instance<AssertionRegistry> assertionRegistry;
    @Inject
    private Instance<TestResultStore> testResultStore;

    public ResponsePayload execute(Manager manager, ServletRequest request, DoFilterCommand filterCommand, ServerAssertion serverAssertion) throws Throwable {
        try {
            request.setAttribute("org.jboss.arquillian.warp.MANAGER_REQUEST_ATTRIBUTE", this.lifecycleManagerStore);
            manager.fire((Object)new BeforeSuite());
            manager.fire((Object)new BeforeRequest(request));
            ((LifecycleManagerStoreImpl)((Object)this.lifecycleManagerStore.get())).bind(ServletRequest.class, request);
            ((AssertionRegistry)this.assertionRegistry.get()).registerAssertion(serverAssertion);
            ((LifecycleManagerImpl)this.lifecycleManager.get()).fireLifecycleEvent(new BeforeServletEvent());
            filterCommand.executeFilterChain();
            ((LifecycleManagerImpl)this.lifecycleManager.get()).fireLifecycleEvent(new AfterServletEvent());
            ResponsePayload responsePayload = this.processTestResult(serverAssertion);
            return responsePayload;
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            ((AssertionRegistry)this.assertionRegistry.get()).unregisterAssertion(serverAssertion);
            ((LifecycleManagerStoreImpl)((Object)this.lifecycleManagerStore.get())).unbind(ServletRequest.class, request);
            manager.fire((Object)new AfterRequest(request));
            manager.fire((Object)new AfterSuite());
        }
    }

    private ResponsePayload processTestResult(ServerAssertion serverAssertion) {
        TestResult firstFailedResult = ((TestResultStore)this.testResultStore.get()).getFirstFailed();
        if (firstFailedResult == null) {
            return new ResponsePayload(serverAssertion);
        }
        Throwable throwable = firstFailedResult.getThrowable();
        if (throwable instanceof InvocationTargetException) {
            throwable = throwable.getCause();
        }
        return new ResponsePayload(throwable);
    }
}

