/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.warp.server.lifecycle;

import org.jboss.arquillian.core.api.Injector;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.InstanceProducer;
import org.jboss.arquillian.core.api.annotation.ApplicationScoped;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.core.api.event.ManagerStarted;
import org.jboss.arquillian.warp.server.assertion.AssertionRegistry;
import org.jboss.arquillian.warp.server.lifecycle.LifecycleManagerImpl;
import org.jboss.arquillian.warp.server.lifecycle.LifecycleManagerStoreImpl;
import org.jboss.arquillian.warp.server.lifecycle.StoreHasAssociatedObjectsException;
import org.jboss.arquillian.warp.server.request.AfterRequest;
import org.jboss.arquillian.warp.server.request.BeforeRequest;
import org.jboss.arquillian.warp.server.request.RequestScoped;
import org.jboss.arquillian.warp.server.test.TestResultStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LifecycleManagerService {
    @Inject
    @ApplicationScoped
    private InstanceProducer<LifecycleManagerStoreImpl> store;
    @Inject
    @RequestScoped
    private InstanceProducer<LifecycleManagerImpl> manager;
    @Inject
    @RequestScoped
    private InstanceProducer<AssertionRegistry> registry;
    @Inject
    @RequestScoped
    private InstanceProducer<TestResultStore> testResultStore;
    @Inject
    private Instance<Injector> injector;

    public void initializeStore(@Observes ManagerStarted event) {
        this.store.set((Object)this.inject(new LifecycleManagerStoreImpl()));
    }

    private <T> T inject(T object) {
        return (T)((Injector)this.injector.get()).inject(object);
    }

    public void initializeManagerAndDriver(@Observes BeforeRequest event) {
        this.manager.set((Object)this.inject(new LifecycleManagerImpl()));
        this.registry.set((Object)this.inject(new AssertionRegistry()));
        this.testResultStore.set((Object)this.inject(new TestResultStore()));
    }

    public void finalizeManager(@Observes AfterRequest event) {
        try {
            this.getStore().verifyManagerUnbound();
        }
        catch (StoreHasAssociatedObjectsException e) {
            throw new IllegalStateException(e);
        }
    }

    private LifecycleManagerStoreImpl getStore() {
        return (LifecycleManagerStoreImpl)((Object)this.store.get());
    }
}

