/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.warp.server.lifecycle;

import java.util.HashMap;
import java.util.HashSet;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.spi.Validate;
import org.jboss.arquillian.warp.server.lifecycle.LifecycleManagerImpl;
import org.jboss.arquillian.warp.server.lifecycle.StoreHasAssociatedObjectsException;
import org.jboss.arquillian.warp.spi.LifecycleManagerStore;
import org.jboss.arquillian.warp.spi.ObjectAlreadyAssociatedException;
import org.jboss.arquillian.warp.spi.ObjectNotAssociatedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LifecycleManagerStoreImpl
extends LifecycleManagerStore {
    private static ConcurrentHashMap<Class<?>, Binding> STORE = new ConcurrentHashMap();
    private static ConcurrentHashMap<LifecycleManagerImpl, Tracking> TRACK = new ConcurrentHashMap();
    @Inject
    Instance<LifecycleManagerImpl> manager;

    public static <T> LifecycleManagerImpl get(Class<T> clazz, T boundObject) throws ObjectNotAssociatedException {
        Validate.notNull(boundObject, (String)"boundObject must not be null");
        Binding binding = STORE.get(clazz);
        if (binding == null) {
            throw new ObjectNotAssociatedException();
        }
        LifecycleManagerImpl manager = (LifecycleManagerImpl)binding.get(boundObject);
        if (manager == null) {
            throw new ObjectNotAssociatedException();
        }
        return manager;
    }

    public <T> void bind(Class<T> clazz, T object) throws ObjectAlreadyAssociatedException {
        LifecycleManagerImpl manager = this.getManager();
        STORE.putIfAbsent(clazz, new Binding());
        Binding binding = STORE.get(clazz);
        if (binding.put(object, manager) != null) {
            throw new ObjectAlreadyAssociatedException();
        }
        TRACK.putIfAbsent(manager, new Tracking());
        Tracking tracking = TRACK.get(manager);
        tracking.add(clazz);
    }

    public <T> void unbind(Class<T> clazz, T object) throws ObjectNotAssociatedException {
        LifecycleManagerImpl manager = this.getManager();
        Binding binding = STORE.get(clazz);
        if (binding == null) {
            throw new ObjectNotAssociatedException();
        }
        if (!binding.containsKey(object)) {
            throw new ObjectNotAssociatedException();
        }
        binding.remove(object);
        Tracking tracking = TRACK.get(manager);
        tracking.remove(clazz);
    }

    public <T> void verifyManagerUnbound() throws StoreHasAssociatedObjectsException {
        LifecycleManagerImpl manager = this.getManager();
        Tracking tracking = TRACK.get(manager);
        if (tracking != null) {
            if (!tracking.isEmpty()) {
                throw new StoreHasAssociatedObjectsException();
            }
            TRACK.remove(manager);
        }
    }

    private LifecycleManagerImpl getManager() {
        return (LifecycleManagerImpl)this.manager.get();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Tracking
    extends HashSet<Class<?>> {
        private Tracking() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Binding
    extends HashMap<Object, LifecycleManagerImpl> {
        private Binding() {
        }
    }
}

