/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.warp.extension.phaser;

import java.lang.annotation.Annotation;
import javax.faces.event.PhaseId;
import org.jboss.arquillian.core.spi.Validate;
import org.jboss.arquillian.warp.extension.phaser.AfterPhase;
import org.jboss.arquillian.warp.extension.phaser.BeforePhase;
import org.jboss.arquillian.warp.extension.phaser.Phase;
import org.jboss.arquillian.warp.extension.phaser.When;
import org.jboss.arquillian.warp.spi.LifecycleEvent;

public class PhaseLifecycleEvent
extends LifecycleEvent {
    private Phase phase;
    private When when;

    public PhaseLifecycleEvent(PhaseId phaseId, When when) {
        Validate.notNull((Object)phaseId, (String)"phaseId must not be null");
        this.phase = this.getPhase(phaseId);
        this.when = when;
    }

    public Annotation getAnnotation() {
        switch (this.when) {
            case BEFORE: {
                return new BeforePhase(){

                    @Override
                    public Class<? extends Annotation> annotationType() {
                        return BeforePhase.class;
                    }

                    @Override
                    public Phase value() {
                        return PhaseLifecycleEvent.this.phase;
                    }
                };
            }
            case AFTER: {
                return new AfterPhase(){

                    @Override
                    public Class<? extends Annotation> annotationType() {
                        return AfterPhase.class;
                    }

                    @Override
                    public Phase value() {
                        return PhaseLifecycleEvent.this.phase;
                    }
                };
            }
        }
        throw new IllegalStateException();
    }

    private Phase getPhase(PhaseId phaseId) {
        if (phaseId == PhaseId.APPLY_REQUEST_VALUES) {
            return Phase.APPLY_REQUEST_VALUES;
        }
        if (phaseId == PhaseId.INVOKE_APPLICATION) {
            return Phase.INVOKE_APPLICATION;
        }
        if (phaseId == PhaseId.PROCESS_VALIDATIONS) {
            return Phase.PROCESS_VALIDATIONS;
        }
        if (phaseId == PhaseId.RENDER_RESPONSE) {
            return Phase.RENDER_RESPONSE;
        }
        if (phaseId == PhaseId.RESTORE_VIEW) {
            return Phase.RESTORE_VIEW;
        }
        if (phaseId == PhaseId.UPDATE_MODEL_VALUES) {
            return Phase.UPDATE_MODEL_VALUES;
        }
        throw new UnsupportedOperationException("the phaseId '" + phaseId + "' is not supported");
    }
}

