/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.warp.extension.phaser;

import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import org.jboss.arquillian.warp.extension.phaser.PhaseLifecycleEvent;
import org.jboss.arquillian.warp.extension.phaser.PhaserFacesContextFactoryWrapper;
import org.jboss.arquillian.warp.extension.phaser.When;
import org.jboss.arquillian.warp.spi.LifecycleEvent;
import org.jboss.arquillian.warp.spi.LifecycleManager;
import org.jboss.arquillian.warp.spi.LifecycleManagerStore;
import org.jboss.arquillian.warp.spi.ObjectNotAssociatedException;

public class PhaserListener
implements PhaseListener {
    public void beforePhase(PhaseEvent event) {
        this.executeEvents(When.BEFORE, event);
    }

    public void afterPhase(PhaseEvent event) {
        this.executeEvents(When.AFTER, event);
    }

    public PhaseId getPhaseId() {
        return PhaseId.ANY_PHASE;
    }

    private void executeEvents(When when, PhaseEvent event) {
        FacesContext facesContext = event.getFacesContext();
        Boolean initialized = (Boolean)facesContext.getAttributes().get(PhaserFacesContextFactoryWrapper.INITIALIZED);
        if (initialized.booleanValue()) {
            try {
                LifecycleManager manager = LifecycleManagerStore.get(FacesContext.class, (Object)event.getFacesContext());
                manager.fireLifecycleEvent((LifecycleEvent)new PhaseLifecycleEvent(event.getPhaseId(), when));
            }
            catch (ObjectNotAssociatedException e) {
                throw new IllegalStateException(e);
            }
        }
    }
}

