/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.warp.spi;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.jboss.arquillian.warp.spi.LifecycleManager;
import org.jboss.arquillian.warp.spi.ObjectAlreadyAssociatedException;
import org.jboss.arquillian.warp.spi.ObjectNotAssociatedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LifecycleManagerStore {
    private static final String LIFECYCLE_MANAGER_STORE_IMPLEMENTATION = "org.jboss.arquillian.warp.server.lifecycle.LifecycleManagerStoreImpl";

    public abstract <T> void bind(Class<T> var1, T var2) throws ObjectAlreadyAssociatedException;

    public abstract <T> void unbind(Class<T> var1, T var2) throws ObjectNotAssociatedException;

    public static <T> LifecycleManager get(Class<T> clazz, T boundObject) throws ObjectNotAssociatedException {
        try {
            Class<?> implementation = Class.forName(LIFECYCLE_MANAGER_STORE_IMPLEMENTATION);
            Method getMethod = implementation.getMethod("get", Object.class.getClass(), Object.class);
            return (LifecycleManager)getMethod.invoke(null, clazz, boundObject);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof ObjectNotAssociatedException) {
                throw (ObjectNotAssociatedException)e.getCause();
            }
            throw new IllegalStateException(e);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("The org.jboss.arquillian.warp.server.lifecycle.LifecycleManagerStoreImplis not available on classpath, check that you have arquillian-warp-impl.jar on classpath");
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("The static method get was not found on LifecycleManagerStore: org.jboss.arquillian.warp.server.lifecycle.LifecycleManagerStoreImpl");
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }
}

