/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.context;

import java.util.concurrent.CountDownLatch;
import org.jboss.arquillian.graphene.context.GrapheneContext;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.openqa.selenium.WebDriver;

public class TestGrapheneContextTheadLocality {
    @Test
    public void context_holds_one_instance_per_thread() {
        final CountDownLatch secondInstanceSet = new CountDownLatch(1);
        final CountDownLatch firstInstanceVerified = new CountDownLatch(1);
        final WebDriver driver1 = (WebDriver)Mockito.mock(WebDriver.class);
        final WebDriver driver2 = (WebDriver)Mockito.mock(WebDriver.class);
        new Thread(new Runnable(){

            public void run() {
                GrapheneContext.set((WebDriver)driver1);
                TestGrapheneContextTheadLocality.this.await(secondInstanceSet);
                Assert.assertSame((Object)driver1, (Object)GrapheneContext.get());
                firstInstanceVerified.countDown();
            }
        }).start();
        new Thread(new Runnable(){

            public void run() {
                GrapheneContext.set((WebDriver)driver2);
                secondInstanceSet.countDown();
                Assert.assertSame((Object)driver2, (Object)GrapheneContext.get());
            }
        }).start();
        this.await(firstInstanceVerified);
    }

    private void await(CountDownLatch condition) {
        try {
            condition.await();
        }
        catch (InterruptedException e) {
            Assert.fail((String)"thread has been interrupted");
        }
    }
}

