/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene;

import org.jboss.arquillian.graphene.condition.AttributeConditionFactory;
import org.jboss.arquillian.graphene.condition.ElementConditionFactory;
import org.jboss.arquillian.graphene.condition.attribute.ElementAttributeConditionFactory;
import org.jboss.arquillian.graphene.condition.element.WebElementConditionFactory;
import org.jboss.arquillian.graphene.condition.locator.ElementLocatorConditionFactory;
import org.jboss.arquillian.graphene.configuration.GrapheneConfiguration;
import org.jboss.arquillian.graphene.context.GrapheneConfigurationContext;
import org.jboss.arquillian.graphene.context.GrapheneContext;
import org.jboss.arquillian.graphene.enricher.PageFragmentEnricher;
import org.jboss.arquillian.graphene.guard.RequestGuardFactory;
import org.jboss.arquillian.graphene.page.RequestType;
import org.jboss.arquillian.graphene.wait.WebDriverWait;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Graphene {
    public static AttributeConditionFactory attribute(WebElement element, String attribute) {
        return new ElementAttributeConditionFactory(element, attribute);
    }

    public static ElementConditionFactory element(WebElement element) {
        return new WebElementConditionFactory(element);
    }

    public static ElementConditionFactory element(By locator) {
        return new ElementLocatorConditionFactory(locator);
    }

    public static <T> T guardHttp(T target) {
        return RequestGuardFactory.guard(target, RequestType.HTTP);
    }

    public static <T> T guardNoRequest(T target) {
        return RequestGuardFactory.guard(target, RequestType.NONE);
    }

    public static <T> T guardXhr(T target) {
        return RequestGuardFactory.guard(target, RequestType.XHR);
    }

    public static WebDriverWait<Void> waitAjax() {
        return Graphene.waitAjax(GrapheneContext.getProxy());
    }

    public static WebDriverWait<Void> waitAjax(WebDriver driver) {
        return new WebDriverWait<Object>(null, driver, Graphene.getConfiguration().getWaitAjaxInterval());
    }

    public static WebDriverWait<Void> waitGui() {
        return Graphene.waitGui(GrapheneContext.getProxy());
    }

    public static WebDriverWait<Void> waitGui(WebDriver driver) {
        return new WebDriverWait<Object>(null, driver, Graphene.getConfiguration().getWaitGuiInterval());
    }

    public static WebDriverWait<Void> waitModel() {
        return Graphene.waitModel(GrapheneContext.getProxy());
    }

    public static WebDriverWait<Void> waitModel(WebDriver driver) {
        return new WebDriverWait<Object>(null, driver, Graphene.getConfiguration().getWaitModelInterval());
    }

    public static <T> T createPageFragment(Class<T> clazz, WebElement root) {
        return PageFragmentEnricher.createPageFragment(clazz, root);
    }

    private static GrapheneConfiguration getConfiguration() {
        return GrapheneConfigurationContext.getProxy();
    }
}

