/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.cglib;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jboss.arquillian.graphene.shaded.net.sf.cglib.core.DefaultNamingPolicy;
import org.jboss.arquillian.graphene.shaded.net.sf.cglib.core.NamingPolicy;
import org.jboss.arquillian.graphene.shaded.net.sf.cglib.core.Predicate;
import org.jboss.arquillian.graphene.shaded.net.sf.cglib.proxy.Callback;
import org.jboss.arquillian.graphene.shaded.net.sf.cglib.proxy.CallbackFilter;
import org.jboss.arquillian.graphene.shaded.net.sf.cglib.proxy.Enhancer;
import org.jboss.arquillian.graphene.shaded.net.sf.cglib.proxy.Factory;
import org.jboss.arquillian.graphene.shaded.net.sf.cglib.proxy.MethodInterceptor;
import org.jboss.arquillian.graphene.shaded.net.sf.cglib.proxy.NoOp;
import org.jboss.arquillian.graphene.shaded.org.objenesis.Objenesis;
import org.jboss.arquillian.graphene.shaded.org.objenesis.ObjenesisStd;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassImposterizer {
    private final Objenesis objenesis = new ObjenesisStd();
    private static final NamingPolicy DEFAULT_POLICY = new DefaultNamingPolicy(){

        protected String getTag() {
            return "CGLIB";
        }
    };
    private static final NamingPolicy SIGNED_CLASSES_POLICY = new DefaultNamingPolicy(){

        public String getClassName(String prefix, String source, Object key, Predicate names) {
            return "codegen." + super.getClassName(prefix, source, key, names);
        }

        protected String getTag() {
            return "CGLIB";
        }
    };
    private static final CallbackFilter IGNORE_BRIDGE_METHODS = new CallbackFilter(){

        public int accept(Method method) {
            return method.isBridge() ? 1 : 0;
        }
    };

    protected ClassImposterizer() {
    }

    protected <T> T imposteriseProtected(MethodInterceptor interceptor, Class<?> mockedType, Class<?> ... ancillaryTypes) {
        if (mockedType.isInterface()) {
            return this.imposteriseInterface(interceptor, mockedType, ancillaryTypes);
        }
        return this.imposteriseClass(interceptor, mockedType, ancillaryTypes);
    }

    protected <T> T imposteriseClass(MethodInterceptor interceptor, Class<?> mockedType, Class<?> ... ancillaryTypes) {
        this.setConstructorsAccessible(mockedType, true);
        Class<?> proxyClass = this.createProxyClass(mockedType, ancillaryTypes);
        return (T)mockedType.cast(this.createProxy(proxyClass, interceptor));
    }

    protected <T> T imposteriseInterface(MethodInterceptor interceptor, Class<?> mockedInterface, Class<?> ... ancillaryTypes) {
        if (!Modifier.isPublic(mockedInterface.getModifiers())) {
            throw new IllegalArgumentException("Imposterized interface must be public: " + mockedInterface);
        }
        ArrayList list = new ArrayList(Arrays.asList(ancillaryTypes));
        list.add(mockedInterface);
        Class[] interfaces = list.toArray(new Class[list.size()]);
        return this.imposteriseClass(interceptor, Object.class, interfaces);
    }

    private void setConstructorsAccessible(Class<?> mockedType, boolean accessible) {
        for (Constructor<?> constructor : mockedType.getDeclaredConstructors()) {
            constructor.setAccessible(accessible);
        }
    }

    private Class<?> createProxyClass(Class<?> mockedType, Class<?> ... interfaces) {
        if (mockedType == Object.class) {
            mockedType = ClassWithSuperclassToWorkAroundCglibBug.class;
        }
        ClassEnhancer enhancer = new ClassEnhancer();
        enhancer.setUseFactory(true);
        enhancer.setSuperclass(mockedType);
        enhancer.setInterfaces(interfaces);
        enhancer.setCallbackTypes(new Class[]{MethodInterceptor.class, NoOp.class});
        enhancer.setCallbackFilter(IGNORE_BRIDGE_METHODS);
        enhancer.setNamingPolicy(mockedType.getSigners() != null ? SIGNED_CLASSES_POLICY : DEFAULT_POLICY);
        return enhancer.createClass();
    }

    private Object createProxy(Class<?> proxyClass, Callback callback) {
        Factory proxy = (Factory)this.objenesis.newInstance(proxyClass);
        proxy.setCallbacks(new Callback[]{callback, NoOp.INSTANCE});
        return proxy;
    }

    public static class ClassWithSuperclassToWorkAroundCglibBug {
    }

    private static class ClassEnhancer
    extends Enhancer {
        private ClassEnhancer() {
        }

        protected void filterConstructors(Class sc, List constructors) {
        }
    }
}

