/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.intercept;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jboss.arquillian.graphene.context.GrapheneContext;
import org.jboss.arquillian.graphene.intercept.ClassImposterizer;
import org.jboss.arquillian.graphene.proxy.Interceptor;
import org.jboss.arquillian.graphene.proxy.InvocationContext;
import org.jboss.arquillian.graphene.shaded.net.sf.cglib.proxy.MethodInterceptor;
import org.jboss.arquillian.graphene.shaded.net.sf.cglib.proxy.MethodProxy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterceptorBuilder {
    private Map<Method, List<Interceptor>> interceptors = new HashMap<Method, List<Interceptor>>();

    public <T> T interceptInvocation(Class<T> type, final Interceptor interceptor) {
        return ClassImposterizer.INSTANCE.imposterise(new MethodInterceptor(){

            public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
                InterceptorBuilder.this.registerMethodInterceptor(method, interceptor);
                return null;
            }
        }, type, new Class[0]);
    }

    private void registerMethodInterceptor(Method method, Interceptor interceptor) {
        List<Interceptor> list = this.interceptors.get(method);
        if (list == null) {
            list = new LinkedList<Interceptor>();
            this.interceptors.put(method, list);
        }
        list.add(interceptor);
    }

    public Interceptor build() {
        return new Interceptor(){
            final Map<Method, List<Interceptor>> interceptors;
            {
                this.interceptors = new HashMap<Method, List<Interceptor>>(InterceptorBuilder.this.interceptors);
            }

            public Object intercept(final InvocationContext originalContext) throws Throwable {
                Iterator iterator;
                Collection interceptors = this.interceptors.get(originalContext.getMethod());
                if (interceptors != null && (iterator = interceptors.iterator()).hasNext()) {
                    Interceptor interceptor = (Interceptor)iterator.next();
                    return interceptor.intercept(new InvocationContext(){

                        public Object invoke() throws Throwable {
                            if (iterator.hasNext()) {
                                return ((Interceptor)iterator.next()).intercept(this);
                            }
                            return originalContext.invoke();
                        }

                        public Object getTarget() {
                            return originalContext.getTarget();
                        }

                        public Object getProxy() {
                            return originalContext.getProxy();
                        }

                        public Method getMethod() {
                            return originalContext.getMethod();
                        }

                        public Object[] getArguments() {
                            return originalContext.getArguments();
                        }

                        public GrapheneContext getGrapheneContext() {
                            return originalContext.getGrapheneContext();
                        }
                    });
                }
                return originalContext.invoke();
            }
        };
    }
}

