/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.page.extension;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.jboss.arquillian.graphene.javascript.Dependency;
import org.jboss.arquillian.graphene.javascript.JSInterface;
import org.jboss.arquillian.graphene.javascript.JSMethod;
import org.jboss.arquillian.graphene.spi.javascript.JavaScript;
import org.jboss.arquillian.graphene.spi.page.PageExtension;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaScriptPageExtension
implements PageExtension {
    private final JavaScript extensionScript;
    private final JavaScript installationDetectionScript;
    private final Collection<String> required;
    private final JSInterface target;

    public JavaScriptPageExtension(Class<?> clazz) {
        this.target = new JSInterface(clazz);
        if (this.target.getName() == null || this.target.getName().length() == 0) {
            throw new IllegalArgumentException("The JavaScript page extension can be created only for class where @JavaScript annotation defines non empty value(). The given class " + clazz + " is not annotation this way.");
        }
        Dependency dependency = clazz.getAnnotation(Dependency.class);
        if (dependency != null) {
            if (dependency.sources().length == 0 && dependency.interfaces().length != 0) {
                throw new IllegalArgumentException("The JavaScript page extension can't have any interface dependencies when it has no source dependencies. Can't create page extension for " + clazz + ".");
            }
            JavaScript dependencyScript = null;
            for (String source : dependency.sources()) {
                dependencyScript = dependencyScript == null ? JavaScript.fromResource((String)source) : dependencyScript.join(JavaScript.fromResource((String)source));
            }
            if (this.target.isInstallable()) {
                JSMethod installMethod = this.target.getJSMethod("install", new Object[0]);
                String functionCall = this.target.getName() + "." + installMethod.getName() + "();";
                dependencyScript = dependencyScript.join(JavaScript.fromString((String)functionCall));
            }
            this.extensionScript = dependencyScript;
            JavaScript jsInstallationDetection = null;
            StringBuilder builder = new StringBuilder();
            for (String object : this.target.getName().split("\\.")) {
                jsInstallationDetection = jsInstallationDetection == null ? JavaScript.fromString((String)("return (typeof " + object + " != 'undefined')")) : jsInstallationDetection.append(" && (typeof " + builder.toString() + object + " != 'undefined')");
                builder.append(object).append(".");
            }
            this.installationDetectionScript = jsInstallationDetection;
            ArrayList<String> dependencies = new ArrayList<String>();
            for (Class dependencyInterface : dependency.interfaces()) {
                org.jboss.arquillian.graphene.javascript.JavaScript jsDependencyAnnoation = dependencyInterface.getAnnotation(org.jboss.arquillian.graphene.javascript.JavaScript.class);
                if (jsDependencyAnnoation == null) {
                    throw new IllegalArgumentException("There is a dependency " + dependencyInterface + " of " + clazz + " which isn't annotated by @JavaScript annoation. The JavaScript page extension can't be created.");
                }
                if (jsDependencyAnnoation.value() == null || jsDependencyAnnoation.value().length() == 0) {
                    throw new IllegalArgumentException("There is a dependency " + dependencyInterface + " of " + clazz + " where @JavaScript annoation doesn't define non empty value(). The JavaScript page extension can't be created.");
                }
                dependencies.add(jsDependencyAnnoation.value());
            }
            this.required = Collections.unmodifiableCollection(dependencies);
        } else {
            this.installationDetectionScript = JavaScript.fromString((String)"return true;");
            this.extensionScript = JavaScript.fromString((String)"return true;");
            this.required = Collections.unmodifiableCollection(Collections.EMPTY_LIST);
        }
    }

    public String getName() {
        return this.target.getName();
    }

    public JavaScript getExtensionScript() {
        return this.extensionScript;
    }

    public JavaScript getInstallationDetectionScript() {
        return this.installationDetectionScript;
    }

    public Collection<String> getRequired() {
        return this.required;
    }
}

