/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.condition.attribute;

import org.jboss.arquillian.graphene.condition.AbstractBooleanConditionFactory;
import org.jboss.arquillian.graphene.condition.AttributeConditionFactory;
import org.jboss.arquillian.graphene.condition.attribute.AttributeIsPresent;
import org.jboss.arquillian.graphene.condition.attribute.AttributeValueContains;
import org.jboss.arquillian.graphene.condition.attribute.AttributeValueEquals;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.ExpectedCondition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementAttributeConditionFactory
extends AbstractBooleanConditionFactory<AttributeConditionFactory>
implements AttributeConditionFactory {
    private WebElement element;
    private String attribute;

    public ElementAttributeConditionFactory(WebElement element, String attribute) {
        if (element == null) {
            throw new IllegalArgumentException("The element can't be null.");
        }
        if (attribute == null) {
            throw new IllegalArgumentException("The attribute can't be null.");
        }
        this.element = element;
        this.attribute = attribute;
    }

    @Override
    public ExpectedCondition<Boolean> isPresent() {
        return new AttributeIsPresent(this.element, this.attribute, this.getNegation());
    }

    @Override
    protected ElementAttributeConditionFactory copy() {
        ElementAttributeConditionFactory copy = new ElementAttributeConditionFactory(this.element, this.attribute);
        copy.setNegation(this.getNegation());
        return copy;
    }

    @Override
    public ExpectedCondition<Boolean> contains(String expected) {
        return new AttributeValueContains(this.element, this.attribute, expected, this.getNegation());
    }

    @Override
    public ExpectedCondition<Boolean> equalTo(String expected) {
        return new AttributeValueEquals(this.element, this.attribute, expected, this.getNegation());
    }
}

