/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.configuration;

import org.jboss.arquillian.config.descriptor.api.ArquillianDescriptor;
import org.jboss.arquillian.core.api.Event;
import org.jboss.arquillian.core.api.InstanceProducer;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.drone.api.annotation.Default;
import org.jboss.arquillian.graphene.spi.configuration.GrapheneConfiguration;
import org.jboss.arquillian.graphene.spi.configuration.GrapheneConfigured;
import org.jboss.arquillian.graphene.spi.configuration.GrapheneUnconfigured;
import org.jboss.arquillian.test.spi.annotation.ClassScoped;
import org.jboss.arquillian.test.spi.event.suite.AfterClass;
import org.jboss.arquillian.test.spi.event.suite.BeforeClass;

public class GrapheneConfigurator {
    @Inject
    @ClassScoped
    private InstanceProducer<GrapheneConfiguration> configuration;
    @Inject
    private Event<GrapheneConfigured> configuredEvent;
    @Inject
    private Event<GrapheneUnconfigured> unconfiguredEvent;

    public void configureGraphene(@Observes(precedence=100) BeforeClass event, ArquillianDescriptor descriptor) {
        GrapheneConfiguration c = new GrapheneConfiguration();
        c.configure(descriptor, Default.class).validate();
        this.configuration.set((Object)c);
        this.configuredEvent.fire((Object)new GrapheneConfigured(c));
    }

    public void unconfigureGraphene(@Observes(precedence=-100) AfterClass event) {
        this.unconfiguredEvent.fire((Object)new GrapheneUnconfigured((GrapheneConfiguration)this.configuration.get()));
    }
}

