/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.javascript;

import org.jboss.arquillian.graphene.proxy.GrapheneProxyInstance;
import org.jboss.arquillian.graphene.spi.javascript.JavaScript;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.remote.RemoteWebDriver;

public final class JavaScriptUtils {
    private JavaScriptUtils() {
    }

    public static Object execute(JavascriptExecutor executor, JavaScript javaScript, Object ... args) {
        return JavaScriptUtils.execute(executor, javaScript.getSourceCode(), args);
    }

    public static Object execute(JavascriptExecutor executor, String javaScript, Object ... args) {
        try {
            if (JavaScriptUtils.isAndroidDriver(executor)) {
                return executor.executeScript(javaScript.replace("\n", ""), args);
            }
            return executor.executeScript(javaScript, args);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean isAndroidDriver(Object instance) {
        if (instance instanceof GrapheneProxyInstance) {
            return JavaScriptUtils.isAndroidDriver(((GrapheneProxyInstance)instance).unwrap());
        }
        if (instance instanceof RemoteWebDriver) {
            Capabilities capabilities = ((RemoteWebDriver)instance).getCapabilities();
            return "android".equals(capabilities.getBrowserName());
        }
        return false;
    }
}

