/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.bytebuddy;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.NamingStrategy;
import net.bytebuddy.TypeCache;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.modifier.ModifierContributor;
import net.bytebuddy.description.modifier.Visibility;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.MethodDelegation;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.jboss.arquillian.graphene.bytebuddy.MethodInterceptor;
import org.objenesis.Objenesis;
import org.objenesis.ObjenesisStd;

public class ClassImposterizer {
    private final TypeCache<Class<?>> cache = new TypeCache();
    private static final Map<Class<?>, Field> interceptorFields = new ConcurrentHashMap();
    public static final String TAG = "ByGraphene";
    private static final CallbackFilter IGNORED_METHODS = new CallbackFilter();
    private final Objenesis objenesis = new ObjenesisStd();
    private static final ClassImposterizer INSTANCE = new ClassImposterizer();
    private static final DefaultNamingPolicy DEFAULT_POLICY = new DefaultNamingPolicy();
    private static final SignedNamingPolicy SIGNED_POLICY = new SignedNamingPolicy();

    protected ClassImposterizer() {
    }

    protected <T> T imposteriseProtected(MethodInterceptor interceptor, Class<?> mockedType, Class<?> ... ancillaryTypes) {
        if (mockedType.isInterface()) {
            return this.imposteriseInterface(interceptor, mockedType, ancillaryTypes);
        }
        return this.imposteriseClass(interceptor, mockedType, ancillaryTypes);
    }

    protected <T> T imposteriseClass(MethodInterceptor interceptor, Class<?> mockedType, Class<?> ... ancillaryTypes) {
        this.setConstructorsAccessible(mockedType, true);
        Class<?> proxyClass = this.createProxyClass(mockedType, interceptor.getClass(), ancillaryTypes);
        return (T)mockedType.cast(this.createProxy(proxyClass, interceptor));
    }

    protected <T> T imposteriseInterface(MethodInterceptor interceptor, Class<?> mockedInterface, Class<?> ... ancillaryTypes) {
        if (!Modifier.isPublic(mockedInterface.getModifiers())) {
            throw new IllegalArgumentException("Imposterized interface must be public: " + mockedInterface);
        }
        return this.imposteriseClass(interceptor, mockedInterface, ancillaryTypes);
    }

    private void setConstructorsAccessible(Class<?> mockedType, boolean accessible) {
        for (Constructor<?> constructor : mockedType.getDeclaredConstructors()) {
            constructor.setAccessible(accessible);
        }
    }

    private <T> Class<?> createProxyClass(Class<?> mockedType, Class<?> interceptorType, Class<?> ... interfaces) {
        return this.cache.findOrInsert(interceptorType.getClassLoader(), mockedType, () -> this.createProxyClassInternal(mockedType, interceptorType, interfaces));
    }

    private <T> Class<?> createProxyClassInternal(Class<?> mockedType, Class<?> interceptorType, Class<?> ... interfaces) {
        DynamicType.Unloaded unloadedType = new ByteBuddy().with((NamingStrategy)(mockedType.getSigners() != null ? SIGNED_POLICY : DEFAULT_POLICY)).subclass(mockedType).implement((Type[])interfaces).defineField("__interceptor", MethodInterceptor.class, new ModifierContributor.ForField[]{Visibility.PRIVATE}).method((ElementMatcher)ElementMatchers.not((ElementMatcher)ElementMatchers.anyOf((Object[])new Object[]{IGNORED_METHODS, ElementMatchers.isDeclaredBy(Object.class)}))).intercept((Implementation)MethodDelegation.to(interceptorType)).make();
        Class proxyType = unloadedType.load(mockedType.getClassLoader()).getLoaded();
        try {
            Field interceptorField = proxyType.getDeclaredField("__interceptor");
            interceptorField.setAccessible(true);
            interceptorFields.put(proxyType, interceptorField);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        return proxyType;
    }

    private Object createProxy(Class<?> proxyClass, MethodInterceptor interceptor) {
        Object instance = this.objenesis.newInstance(proxyClass);
        try {
            interceptorFields.get(proxyClass).set(instance, interceptor);
            return instance;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private static final class SignedNamingPolicy
    extends NamingStrategy.AbstractBase {
        private SignedNamingPolicy() {
        }

        protected String name(TypeDescription superClass) {
            return String.format("codegen.%s_%s", superClass.getName(), ClassImposterizer.TAG);
        }
    }

    private static final class DefaultNamingPolicy
    extends NamingStrategy.AbstractBase {
        private DefaultNamingPolicy() {
        }

        protected String name(TypeDescription superClass) {
            return String.format("%s_%s", superClass.getName(), ClassImposterizer.TAG);
        }
    }

    private static final class CallbackFilter
    implements ElementMatcher<MethodDescription> {
        private CallbackFilter() {
        }

        public boolean matches(MethodDescription method) {
            return method.isBridge() || this.isGroovyMethod(method);
        }

        private boolean isGroovyMethod(MethodDescription method) {
            String[] groovyIgnores = new String[]{"$", "this$", "super$", "getMetaClass"};
            HashSet<String> groovyPrefixes = new HashSet<String>(Arrays.asList(groovyIgnores));
            for (String prefix : groovyPrefixes) {
                if (!method.getName().startsWith(prefix)) continue;
                return true;
            }
            return false;
        }
    }
}

