/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.junit.container;

import java.util.Collections;
import java.util.List;
import org.jboss.arquillian.container.test.spi.TestRunner;
import org.jboss.arquillian.junit.State;
import org.jboss.arquillian.test.spi.TestResult;
import org.junit.Test;
import org.junit.runner.Description;
import org.junit.runner.JUnitCore;
import org.junit.runner.Request;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;

public class JUnitTestRunner
implements TestRunner {
    protected List<RunListener> getRunListeners() {
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TestResult execute(Class<?> testClass, String methodName) {
        TestResult testResult = new TestResult(TestResult.Status.PASSED);
        ExpectedExceptionHolder exceptionHolder = new ExpectedExceptionHolder();
        try {
            JUnitCore runner = new JUnitCore();
            runner.addListener((RunListener)exceptionHolder);
            for (RunListener listener : this.getRunListeners()) {
                runner.addListener(listener);
            }
            Result result = runner.run(Request.method(testClass, (String)methodName));
            testResult.setThrowable(exceptionHolder.getException());
            if (result.getFailureCount() > 0) {
                testResult.setStatus(TestResult.Status.FAILED);
                testResult.setThrowable(((Failure)result.getFailures().get(0)).getException());
            }
            if (result.getIgnoreCount() > 0) {
                testResult.setStatus(TestResult.Status.SKIPPED);
            }
        }
        catch (Throwable th) {
            testResult.setStatus(TestResult.Status.FAILED);
            testResult.setThrowable(th);
        }
        finally {
            testResult.setEnd(System.currentTimeMillis());
        }
        return testResult;
    }

    private class ExpectedExceptionHolder
    extends RunListener {
        private Throwable exception;

        private ExpectedExceptionHolder() {
        }

        public Throwable getException() {
            return this.exception;
        }

        public void testFinished(Description description) throws Exception {
            Test test = (Test)description.getAnnotation(Test.class);
            if (test != null && test.expected() != Test.None.class) {
                this.exception = State.getTestException();
                State.caughtTestException(null);
            }
        }
    }
}

