/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.testenricher.cdi.container;

import javax.enterprise.inject.spi.BeanManager;
import javax.naming.Context;
import org.jboss.arquillian.core.api.InstanceProducer;
import org.jboss.arquillian.core.api.annotation.ApplicationScoped;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;

public class BeanManagerProducer {
    private static final String STANDARD_BEAN_MANAGER_JNDI_NAME = "java:comp/BeanManager";
    private static final String SERVLET_BEAN_MANAGER_JNDI_NAME = "java:comp/env/BeanManager";
    private static final String JBOSSAS_BEAN_MANAGER_JNDI_NAME = "java:global/test/arquillian-protocol/BeanManager";
    @Inject
    @ApplicationScoped
    private InstanceProducer<BeanManager> beanManagerProducer;

    public void findBeanManager(@Observes Context context) {
        BeanManager manager = this.lookup(context);
        if (manager != null) {
            this.beanManagerProducer.set((Object)manager);
        }
    }

    private BeanManager lookup(Context context) {
        try {
            return (BeanManager)context.lookup(STANDARD_BEAN_MANAGER_JNDI_NAME);
        }
        catch (Exception e) {
            try {
                return (BeanManager)context.lookup(SERVLET_BEAN_MANAGER_JNDI_NAME);
            }
            catch (Exception se) {
                try {
                    return (BeanManager)context.lookup(JBOSSAS_BEAN_MANAGER_JNDI_NAME);
                }
                catch (Exception je) {
                    return null;
                }
            }
        }
    }
}

