/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.testenricher.osgi;

import java.lang.annotation.Annotation;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.InstanceProducer;
import org.jboss.arquillian.core.api.annotation.ApplicationScoped;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.arquillian.test.spi.enricher.resource.ResourceProvider;
import org.jboss.arquillian.testenricher.osgi.BundleContextProvider;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.startlevel.StartLevel;

public class StartLevelProvider
implements ResourceProvider {
    private AtomicBoolean initialized = new AtomicBoolean();
    @Inject
    @ApplicationScoped
    private InstanceProducer<StartLevel> startLevelProducer;
    @Inject
    private Instance<StartLevel> startLevel;

    public boolean canProvide(Class<?> type) {
        return type.isAssignableFrom(StartLevel.class);
    }

    public Object lookup(ArquillianResource resource, Annotation ... qualifiers) {
        this.initialize();
        return this.startLevel.get();
    }

    private void initialize() {
        if (this.initialized.compareAndSet(false, true)) {
            BundleContext syscontext = BundleContextProvider.getBundleContext();
            this.startLevelProducer.set((Object)this.getStartLevel(syscontext));
        }
    }

    private StartLevel getStartLevel(BundleContext syscontext) {
        ServiceReference sref = syscontext.getServiceReference(StartLevel.class.getName());
        return (StartLevel)syscontext.getService(sref);
    }
}

