/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.arquillian.container;

import java.io.IOException;
import java.net.InetAddress;
import java.util.logging.Logger;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;

public final class MBeanServerConnectionProvider {
    private static final Logger log = Logger.getLogger(MBeanServerConnectionProvider.class.getName());
    private final InetAddress hostAddr;
    private final int port;
    private JMXConnector jmxConnector;

    public MBeanServerConnectionProvider(InetAddress hostAddr, int port) {
        this.hostAddr = hostAddr;
        this.port = port;
    }

    public MBeanServerConnection getConnection() {
        String host = this.hostAddr.getHostAddress();
        String urlString = System.getProperty("jmx.service.url", "service:jmx:rmi:///jndi/rmi://" + host + ":" + this.port + "/jmxrmi");
        try {
            if (this.jmxConnector == null) {
                log.fine("Connecting JMXConnector to: " + urlString);
                JMXServiceURL serviceURL = new JMXServiceURL(urlString);
                this.jmxConnector = JMXConnectorFactory.connect(serviceURL, null);
            }
            return this.jmxConnector.getMBeanServerConnection();
        }
        catch (IOException ex) {
            throw new IllegalStateException("Cannot obtain MBeanServerConnection to: " + urlString, ex);
        }
    }
}

