/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.arquillian.service;

import java.util.List;
import org.jboss.as.arquillian.service.ArquillianConfig;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.junit.runner.RunWith;

public class ArquillianRunWithAnnotationProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        CompositeIndex compositeIndex = (CompositeIndex)phaseContext.getDeploymentUnit().getAttachment(Attachments.COMPOSITE_ANNOTATION_INDEX);
        if (compositeIndex == null) {
            return;
        }
        DotName runWithName = DotName.createSimple((String)RunWith.class.getName());
        List instances = compositeIndex.getAnnotations(runWithName);
        if (instances.isEmpty()) {
            return;
        }
        DeploymentUnit deploymentUnitContext = phaseContext.getDeploymentUnit();
        ArquillianConfig arqConfig = new ArquillianConfig(deploymentUnitContext);
        deploymentUnitContext.putAttachment(ArquillianConfig.KEY, (Object)arqConfig);
        for (AnnotationInstance instance : instances) {
            AnnotationTarget target = instance.target();
            if (!(target instanceof ClassInfo)) continue;
            ClassInfo classInfo = (ClassInfo)target;
            String testClassName = classInfo.name().toString();
            arqConfig.addTestClass(testClassName);
        }
    }

    public void undeploy(DeploymentUnit context) {
        context.removeAttachment(ArquillianConfig.KEY);
    }
}

