/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.HashMap;
import java.util.Map;

public enum Attribute {
    UNKNOWN(null),
    ACQUIRE_TIMEOUT("acquire-timeout"),
    BATCHING("batching"),
    CLASS("class"),
    CONCURRENCY_LEVEL("concurrency-level"),
    DEFAULT_CACHE("default-cache"),
    DEFAULT_CACHE_CONTAINER("default-cache-container"),
    EAGER_LOCKING("eager-locking"),
    ENABLED("enabled"),
    EVICTION_EXECUTOR("eviction-executor"),
    EXECUTOR("executor"),
    FETCH_STATE("fetch-state"),
    FLUSH_TIMEOUT("flush-timeout"),
    INDEXING("indexing"),
    INTERVAL("interval"),
    ISOLATION("isolation"),
    JNDI_NAME("jndi-name"),
    L1_LIFESPAN("l1-lifespan"),
    LIFESPAN("lifespan"),
    LISTENER_EXECUTOR("listener-executor"),
    LOCK_TIMEOUT("lock-timeout"),
    MACHINE("machine"),
    MAX_ENTRIES("max-entries"),
    MAX_IDLE("max-idle"),
    MODE("mode"),
    NAME("name"),
    NAMESPACE("xmlns"),
    OWNERS("owners"),
    PASSIVATION("passivation"),
    PATH("path"),
    PRELOAD("preload"),
    PURGE("purge"),
    QUEUE_FLUSH_INTERVAL("queue-flush-interval"),
    QUEUE_SIZE("queue-size"),
    RACK("rack"),
    RELATIVE_TO("relative-to"),
    REMOTE_TIMEOUT("remote-timeout"),
    REPLICATION_QUEUE_EXECUTOR("replication-queue-executor"),
    SHARED("shared"),
    SINGLETON("singleton"),
    SITE("site"),
    STACK("stack"),
    START("start"),
    STOP_TIMEOUT("stop-timeout"),
    STRATEGY("strategy"),
    STRIPING("striping"),
    TIMEOUT("timeout");

    private final String name;
    private static final Map<String, Attribute> attributes;

    private Attribute(String name) {
        this.name = name;
    }

    public String getLocalName() {
        return this.name;
    }

    public static Attribute forName(String localName) {
        Attribute attribute = attributes.get(localName);
        return attribute == null ? UNKNOWN : attribute;
    }

    static {
        HashMap<String, Attribute> map = new HashMap<String, Attribute>();
        for (Attribute attribute : Attribute.values()) {
            String name = attribute.getLocalName();
            if (name == null) continue;
            map.put(name, attribute);
        }
        attributes = map;
    }
}

