/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.metadata.deployment;

import com.arjuna.ats.jbossatx.jta.TransactionManagerService;
import java.io.File;
import java.io.PrintWriter;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.List;
import javax.resource.spi.IllegalStateException;
import javax.resource.spi.ResourceAdapter;
import javax.transaction.TransactionManager;
import org.jboss.as.connector.ConnectorServices;
import org.jboss.as.connector.metadata.deployment.ResourceAdapterDeployment;
import org.jboss.as.connector.registry.ResourceAdapterDeploymentRegistry;
import org.jboss.as.connector.services.AdminObjectReferenceFactoryService;
import org.jboss.as.connector.services.AdminObjectService;
import org.jboss.as.connector.services.ConnectionFactoryReferenceFactoryService;
import org.jboss.as.connector.services.ConnectionFactoryService;
import org.jboss.as.connector.subsystems.connector.ConnectorSubsystemConfiguration;
import org.jboss.as.connector.util.Injection;
import org.jboss.as.naming.ManagedReferenceFactory;
import org.jboss.as.naming.NamingStore;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.naming.service.BinderService;
import org.jboss.jca.common.api.metadata.ironjacamar.IronJacamar;
import org.jboss.jca.common.api.metadata.ra.ConfigProperty;
import org.jboss.jca.common.api.metadata.ra.Connector;
import org.jboss.jca.common.api.metadata.ra.ra16.ConfigProperty16;
import org.jboss.jca.core.api.connectionmanager.ccm.CachedConnectionManager;
import org.jboss.jca.core.api.management.ManagementRepository;
import org.jboss.jca.core.spi.mdr.AlreadyExistsException;
import org.jboss.jca.core.spi.mdr.MetadataRepository;
import org.jboss.jca.core.spi.mdr.NotFoundException;
import org.jboss.jca.core.spi.rar.ResourceAdapterRepository;
import org.jboss.jca.core.spi.transaction.TransactionIntegration;
import org.jboss.jca.deployers.common.AbstractResourceAdapterDeployer;
import org.jboss.jca.deployers.common.CommonDeployment;
import org.jboss.jca.deployers.common.DeployException;
import org.jboss.logging.Logger;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.AbstractServiceListener;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.security.SubjectFactory;

public abstract class AbstractResourceAdapterDeploymentService {
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.deployment.connector");
    protected ResourceAdapterDeployment value;
    protected final InjectedValue<MetadataRepository> mdr = new InjectedValue();
    protected final InjectedValue<ResourceAdapterRepository> raRepository = new InjectedValue();
    protected final InjectedValue<ResourceAdapterDeploymentRegistry> registry = new InjectedValue();
    protected final InjectedValue<ManagementRepository> managementRepository = new InjectedValue();
    protected final InjectedValue<ConnectorSubsystemConfiguration> config = new InjectedValue();
    protected final InjectedValue<TransactionIntegration> txInt = new InjectedValue();
    protected final InjectedValue<SubjectFactory> subjectFactory = new InjectedValue();
    protected final InjectedValue<CachedConnectionManager> ccmValue = new InjectedValue();
    private static final SetContextLoaderAction CLEAR_ACTION = new SetContextLoaderAction(null);

    public ResourceAdapterDeployment getValue() {
        return ConnectorServices.notNull(this.value);
    }

    public void stop(StopContext context) {
        if (this.value != null) {
            String jndi;
            log.debugf("Undeploying: %s", (Object)(this.value.getDeployment() != null ? this.value.getDeployment().getDeploymentName() : ""));
            if (this.registry != null && this.registry.getValue() != null) {
                ((ResourceAdapterDeploymentRegistry)this.registry.getValue()).unregisterResourceAdapterDeployment(this.value);
            }
            if (this.mdr != null && this.mdr.getValue() != null) {
                try {
                    ((MetadataRepository)this.mdr.getValue()).unregisterResourceAdapter(this.value.getDeployment().getDeploymentName());
                }
                catch (Throwable t) {
                    log.warn((Object)"Exception during unregistering deployment", t);
                }
            }
            if (this.mdr != null && this.mdr.getValue() != null && this.value.getDeployment() != null && this.value.getDeployment().getCfs() != null && this.value.getDeployment().getCfJndiNames() != null) {
                for (int i = 0; i < this.value.getDeployment().getCfs().length; ++i) {
                    try {
                        String cf = this.value.getDeployment().getCfs()[i].getClass().getName();
                        jndi = this.value.getDeployment().getCfJndiNames()[i];
                        ((MetadataRepository)this.mdr.getValue()).unregisterJndiMapping(this.value.getDeployment().getURL().toExternalForm(), cf, jndi);
                        continue;
                    }
                    catch (NotFoundException nfe) {
                        log.warn((Object)"Exception during JNDI unbinding", (Throwable)nfe);
                    }
                }
            }
            if (this.mdr != null && this.mdr.getValue() != null && this.value.getDeployment().getAos() != null && this.value.getDeployment().getAoJndiNames() != null) {
                for (int i = 0; i < this.value.getDeployment().getAos().length; ++i) {
                    try {
                        String ao = this.value.getDeployment().getAos()[i].getClass().getName();
                        jndi = this.value.getDeployment().getAoJndiNames()[i];
                        ((MetadataRepository)this.mdr.getValue()).unregisterJndiMapping(this.value.getDeployment().getURL().toExternalForm(), ao, jndi);
                        continue;
                    }
                    catch (NotFoundException nfe) {
                        log.warn((Object)"Exception during JNDI unbinding", (Throwable)nfe);
                    }
                }
            }
            if (this.value.getDeployment() != null && this.value.getDeployment().getResourceAdapter() != null) {
                this.value.getDeployment().getResourceAdapter().stop();
            }
        }
    }

    public Injector<MetadataRepository> getMdrInjector() {
        return this.mdr;
    }

    public Injector<ResourceAdapterRepository> getRaRepositoryInjector() {
        return this.raRepository;
    }

    public Injector<ManagementRepository> getManagementRepositoryInjector() {
        return this.managementRepository;
    }

    public Injector<ResourceAdapterDeploymentRegistry> getRegistryInjector() {
        return this.registry;
    }

    public InjectedValue<ConnectorSubsystemConfiguration> getConfig() {
        return this.config;
    }

    public InjectedValue<TransactionIntegration> getTxIntegration() {
        return this.txInt;
    }

    public Injector<TransactionIntegration> getTxIntegrationInjector() {
        return this.txInt;
    }

    public Injector<ConnectorSubsystemConfiguration> getConfigInjector() {
        return this.config;
    }

    public Injector<SubjectFactory> getSubjectFactoryInjector() {
        return this.subjectFactory;
    }

    public Injector<CachedConnectionManager> getCcmInjector() {
        return this.ccmValue;
    }

    private static class SetContextLoaderAction
    implements PrivilegedAction<Void> {
        private final ClassLoader classLoader;

        public SetContextLoaderAction(ClassLoader classLoader) {
            this.classLoader = classLoader;
        }

        @Override
        public Void run() {
            Thread.currentThread().setContextClassLoader(this.classLoader);
            return null;
        }
    }

    protected abstract class AbstractAS7RaDeployer
    extends AbstractResourceAdapterDeployer {
        private final ServiceContainer serviceContainer;
        protected final URL url;
        protected final String deploymentName;
        protected final File root;
        protected final ClassLoader cl;
        protected final Connector cmd;

        protected AbstractAS7RaDeployer(ServiceContainer serviceContainer, URL url, String deploymentName, File root, ClassLoader cl, Connector cmd) {
            super(true, Logger.getLogger(AbstractAS7RaDeployer.class));
            this.serviceContainer = serviceContainer;
            this.url = url;
            this.deploymentName = deploymentName;
            this.root = root;
            this.cl = cl;
            this.cmd = cmd;
        }

        public abstract CommonDeployment doDeploy() throws Throwable;

        public String[] bindConnectionFactory(URL url, String deployment, Object cf) throws Throwable {
            throw new IllegalStateException("Non-explicit JNDI bindings not supported");
        }

        public String[] bindConnectionFactory(URL url, String deployment, Object cf, final String jndi) throws Throwable {
            ((MetadataRepository)AbstractResourceAdapterDeploymentService.this.mdr.getValue()).registerJndiMapping(url.toExternalForm(), cf.getClass().getName(), jndi);
            this.log.infof("Registered connection factory %s on mdr", (Object)jndi);
            ConnectionFactoryService connectionFactoryService = new ConnectionFactoryService(cf);
            ServiceName connectionFactoryServiceName = ConnectionFactoryService.SERVICE_NAME_BASE.append(new String[]{jndi});
            this.serviceContainer.addService(connectionFactoryServiceName, (Service)connectionFactoryService).setInitialMode(ServiceController.Mode.ACTIVE).install();
            ConnectionFactoryReferenceFactoryService referenceFactoryService = new ConnectionFactoryReferenceFactoryService();
            ServiceName referenceFactoryServiceName = ConnectionFactoryReferenceFactoryService.SERVICE_NAME_BASE.append(new String[]{jndi});
            this.serviceContainer.addService(referenceFactoryServiceName, (Service)referenceFactoryService).addDependency(connectionFactoryServiceName, Object.class, referenceFactoryService.getDataSourceInjector()).setInitialMode(ServiceController.Mode.ACTIVE).install();
            BinderService binderService = new BinderService(jndi.substring(6));
            ServiceName binderServiceName = ContextNames.JAVA_CONTEXT_SERVICE_NAME.append(new String[]{jndi});
            this.serviceContainer.addService(binderServiceName, (Service)binderService).addDependency(referenceFactoryServiceName, ManagedReferenceFactory.class, binderService.getManagedObjectInjector()).addDependency(ContextNames.JAVA_CONTEXT_SERVICE_NAME, NamingStore.class, binderService.getNamingStoreInjector()).addDependency(ConnectorServices.RESOURCE_ADAPTER_SERVICE_PREFIX.append(new String[]{this.deploymentName})).addListener((ServiceListener)new AbstractServiceListener<Object>(){

                public void serviceStarted(ServiceController<?> controller) {
                    AbstractAS7RaDeployer.this.log.infof("Bound JCA ConnectionFactory [%s]", (Object)jndi);
                }

                public void serviceStopped(ServiceController<?> serviceController) {
                    AbstractAS7RaDeployer.this.log.infof("Unbound JCA ConnectionFactory [%s]", (Object)jndi);
                }

                public void serviceRemoved(ServiceController<?> serviceController) {
                    AbstractAS7RaDeployer.this.log.debugf("Removed JCA ConnectionFactory [%s]", (Object)jndi);
                    serviceController.removeListener((ServiceListener)this);
                }
            }).setInitialMode(ServiceController.Mode.ACTIVE).install();
            return new String[]{jndi};
        }

        public String[] bindAdminObject(URL url, String deployment, Object ao) throws Throwable {
            throw new IllegalStateException("Non-explicit JNDI bindings not supported");
        }

        public String[] bindAdminObject(URL url, String deployment, Object ao, final String jndi) throws Throwable {
            ((MetadataRepository)AbstractResourceAdapterDeploymentService.this.mdr.getValue()).registerJndiMapping(url.toExternalForm(), ao.getClass().getName(), jndi);
            this.log.infof("Registerred admin object at %s on mdr", (Object)jndi);
            AdminObjectService adminObjectService = new AdminObjectService(ao);
            ServiceName adminObjectServiceName = AdminObjectService.SERVICE_NAME_BASE.append(new String[]{jndi});
            this.serviceContainer.addService(adminObjectServiceName, (Service)adminObjectService).setInitialMode(ServiceController.Mode.ACTIVE).install();
            AdminObjectReferenceFactoryService referenceFactoryService = new AdminObjectReferenceFactoryService();
            ServiceName referenceFactoryServiceName = AdminObjectReferenceFactoryService.SERVICE_NAME_BASE.append(new String[]{jndi});
            this.serviceContainer.addService(referenceFactoryServiceName, (Service)referenceFactoryService).addDependency(adminObjectServiceName, Object.class, referenceFactoryService.getDataSourceInjector()).setInitialMode(ServiceController.Mode.ACTIVE).install();
            BinderService binderService = new BinderService(jndi.substring(6));
            ServiceName binderServiceName = ContextNames.JAVA_CONTEXT_SERVICE_NAME.append(new String[]{jndi});
            this.serviceContainer.addService(binderServiceName, (Service)binderService).addDependency(referenceFactoryServiceName, ManagedReferenceFactory.class, binderService.getManagedObjectInjector()).addDependency(ContextNames.JAVA_CONTEXT_SERVICE_NAME, NamingStore.class, binderService.getNamingStoreInjector()).addListener((ServiceListener)new AbstractServiceListener<Object>(){

                public void serviceStarted(ServiceController<?> controller) {
                    AbstractAS7RaDeployer.this.log.infof("Bound JCA AdminObject [%s]", (Object)jndi);
                }

                public void serviceStopped(ServiceController<?> serviceController) {
                    AbstractAS7RaDeployer.this.log.infof("Unbound JCA AdminObject [%s]", (Object)jndi);
                }

                public void serviceRemoved(ServiceController<?> serviceController) {
                    AbstractAS7RaDeployer.this.log.debugf("Removed JCA AdminObject [%s]", (Object)jndi);
                    serviceController.removeListener((ServiceListener)this);
                }
            }).setInitialMode(ServiceController.Mode.ACTIVE).install();
            return new String[]{jndi};
        }

        protected abstract boolean checkActivation(Connector var1, IronJacamar var2);

        protected boolean checkConfigurationIsValid() {
            return this.getConfiguration() != null;
        }

        protected PrintWriter getLogPrintWriter() {
            return new PrintWriter(System.out);
        }

        protected File getReportDirectory() {
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected TransactionManager getTransactionManager() {
            AccessController.doPrivileged(new SetContextLoaderAction(TransactionManagerService.class.getClassLoader()));
            try {
                TransactionManager transactionManager = ((TransactionIntegration)AbstractResourceAdapterDeploymentService.this.getTxIntegration().getValue()).getTransactionManager();
                return transactionManager;
            }
            finally {
                AccessController.doPrivileged(CLEAR_ACTION);
            }
        }

        public Object initAndInject(String className, List<? extends ConfigProperty> configs, ClassLoader cl) throws DeployException {
            try {
                Class<?> clz = Class.forName(className, true, cl);
                Object o = clz.newInstance();
                if (configs != null) {
                    Injection injector = new Injection();
                    for (ConfigProperty configProperty : configs) {
                        ConfigProperty16 cpmd16;
                        if (!configProperty.isValueSet()) continue;
                        boolean setValue = true;
                        if (configProperty instanceof ConfigProperty16 && (cpmd16 = (ConfigProperty16)configProperty).getConfigPropertyIgnore() != null && cpmd16.getConfigPropertyIgnore().booleanValue()) {
                            setValue = false;
                        }
                        if (!setValue) continue;
                        injector.inject(configProperty.getConfigPropertyType().getValue(), configProperty.getConfigPropertyName().getValue(), configProperty.getConfigPropertyValue().getValue(), o);
                    }
                }
                return o;
            }
            catch (Throwable t) {
                throw new DeployException("Deployment " + className + " failed", t);
            }
        }

        protected void registerResourceAdapterToMDR(URL url, File file, Connector connector, IronJacamar ij) throws AlreadyExistsException {
            this.log.debugf("Registering ResourceAdapter %s", (Object)this.deploymentName);
            ((MetadataRepository)AbstractResourceAdapterDeploymentService.this.mdr.getValue()).registerResourceAdapter(this.deploymentName, file, connector, ij);
        }

        protected String registerResourceAdapterToResourceAdapterRepository(ResourceAdapter instance) {
            return ((ResourceAdapterRepository)AbstractResourceAdapterDeploymentService.this.raRepository.getValue()).registerResourceAdapter(instance);
        }

        protected SubjectFactory getSubjectFactory(String securityDomain) throws DeployException {
            if (securityDomain == null || securityDomain.trim().equals("")) {
                return null;
            }
            return (SubjectFactory)AbstractResourceAdapterDeploymentService.this.subjectFactory.getValue();
        }

        protected TransactionIntegration getTransactionIntegration() {
            return (TransactionIntegration)AbstractResourceAdapterDeploymentService.this.getTxIntegration().getValue();
        }

        protected CachedConnectionManager getCachedConnectionManager() {
            return (CachedConnectionManager)AbstractResourceAdapterDeploymentService.this.ccmValue.getValue();
        }

        protected String buildJndiName(String jndiName, Boolean javaContext) {
            return super.buildJndiName(jndiName, javaContext);
        }
    }
}

