/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.pool;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jboss.as.connector.ConnectorServices;
import org.jboss.as.controller.BasicOperationResult;
import org.jboss.as.controller.ModelQueryOperationHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationResult;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.controller.RuntimeTask;
import org.jboss.as.controller.RuntimeTaskContext;
import org.jboss.dmr.ModelNode;
import org.jboss.jca.core.api.management.ConnectionFactory;
import org.jboss.jca.core.api.management.Connector;
import org.jboss.jca.core.api.management.DataSource;
import org.jboss.jca.core.api.management.ManagementRepository;
import org.jboss.jca.core.connectionmanager.pool.mcp.ManagedConnectionPoolStatisticsImpl;
import org.jboss.jca.core.spi.statistics.StatisticsPlugin;
import org.jboss.msc.service.ServiceController;

public abstract class PoolMetrics
implements ModelQueryOperationHandler {
    static final String[] NO_LOCATION = new String[0];
    public static final Set<String> ATTRIBUTES = new ManagedConnectionPoolStatisticsImpl(1).getNames();

    public OperationResult execute(OperationContext context, final ModelNode operation, final ResultHandler resultHandler) throws OperationFailedException {
        if (context.getRuntimeContext() != null) {
            context.getRuntimeContext().setRuntimeTask(new RuntimeTask(){

                public void execute(RuntimeTaskContext context) throws OperationFailedException {
                    PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
                    String jndiName = address.getLastElement().getValue();
                    String attributeName = operation.require("name").asString();
                    ServiceController managementRepoService = context.getServiceRegistry().getService(ConnectorServices.MANAGEMENT_REPOSISTORY_SERVICE);
                    if (managementRepoService != null) {
                        try {
                            ManagementRepository repository = (ManagementRepository)managementRepoService.getValue();
                            ModelNode result = new ModelNode();
                            List<StatisticsPlugin> stats = PoolMetrics.this.getMatchingStats(jndiName, repository);
                            for (StatisticsPlugin stat : stats) {
                                result.set("" + stat.getValue(attributeName));
                            }
                            resultHandler.handleResultFragment(new String[0], result);
                            resultHandler.handleResultComplete();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            throw new OperationFailedException(new ModelNode().set("failed to get metrics " + e.getMessage()));
                        }
                    }
                }
            });
        } else {
            resultHandler.handleResultFragment(NO_LOCATION, new ModelNode().set("no metrics available"));
            resultHandler.handleResultComplete();
        }
        return new BasicOperationResult();
    }

    protected abstract List<StatisticsPlugin> getMatchingStats(String var1, ManagementRepository var2);

    public static class RaPoolMetricsHandler
    extends PoolMetrics {
        public static RaPoolMetricsHandler INSTANCE = new RaPoolMetricsHandler();

        @Override
        protected List<StatisticsPlugin> getMatchingStats(String jndiName, ManagementRepository repository) {
            ArrayList<StatisticsPlugin> result = new ArrayList<StatisticsPlugin>(repository.getConnectors().size());
            if (repository.getConnectors() != null) {
                for (Connector c : repository.getConnectors()) {
                    if (!jndiName.equalsIgnoreCase(c.getUniqueId()) || c.getConnectionFactories() == null || c.getConnectionFactories().get(0) == null || ((ConnectionFactory)c.getConnectionFactories().get(0)).getPool() == null) continue;
                    result.add((StatisticsPlugin)((ConnectionFactory)c.getConnectionFactories().get(0)).getPool().getStatistics());
                }
            }
            result.trimToSize();
            return result;
        }
    }

    public static class LocalAndXaDataSourcePoolMetricsHandler
    extends PoolMetrics {
        public static LocalAndXaDataSourcePoolMetricsHandler INSTANCE = new LocalAndXaDataSourcePoolMetricsHandler();

        @Override
        protected List<StatisticsPlugin> getMatchingStats(String jndiName, ManagementRepository repository) {
            ArrayList<StatisticsPlugin> result = new ArrayList<StatisticsPlugin>(repository.getDataSources().size());
            if (repository.getDataSources() != null) {
                for (DataSource ds : repository.getDataSources()) {
                    if (!jndiName.equalsIgnoreCase(ds.getJndiName()) || ds.getPool() == null) continue;
                    result.add((StatisticsPlugin)ds.getPool().getStatistics());
                }
            }
            result.trimToSize();
            return result;
        }
    }
}

