/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.subsystems.datasources;

import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Driver;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.resource.ResourceException;
import javax.resource.spi.ManagedConnectionFactory;
import org.jboss.as.connector.util.Injection;
import org.jboss.jca.adapters.jdbc.BaseWrapperManagedConnectionFactory;
import org.jboss.jca.adapters.jdbc.local.LocalManagedConnectionFactory;
import org.jboss.jca.adapters.jdbc.spi.ClassLoaderPlugin;
import org.jboss.jca.adapters.jdbc.xa.XAManagedConnectionFactory;
import org.jboss.jca.common.api.metadata.common.Extension;
import org.jboss.jca.common.api.metadata.ds.CommonDataSource;
import org.jboss.jca.common.api.metadata.ds.DataSource;
import org.jboss.jca.common.api.metadata.ds.DataSources;
import org.jboss.jca.common.api.metadata.ds.DsSecurity;
import org.jboss.jca.common.api.metadata.ds.Statement;
import org.jboss.jca.common.api.metadata.ds.TimeOut;
import org.jboss.jca.common.api.metadata.ds.Validation;
import org.jboss.jca.common.api.metadata.ds.XaDataSource;
import org.jboss.jca.common.api.metadata.ra.ConfigProperty;
import org.jboss.jca.common.api.metadata.ra.ra16.ConfigProperty16;
import org.jboss.jca.common.api.validator.ValidateException;
import org.jboss.jca.common.metadata.ds.DatasourcesImpl;
import org.jboss.jca.core.api.management.ManagementRepository;
import org.jboss.jca.core.spi.mdr.NotFoundException;
import org.jboss.jca.core.spi.transaction.TransactionIntegration;
import org.jboss.jca.deployers.common.AbstractDsDeployer;
import org.jboss.jca.deployers.common.CommonDeployment;
import org.jboss.jca.deployers.common.DeployException;
import org.jboss.logging.Logger;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.security.SubjectFactory;

public abstract class AbstractDataSourceService
implements Service<javax.sql.DataSource> {
    public static final Logger log = Logger.getLogger((String)"org.jboss.as.connector.deployer.dsdeployer");
    public static final ServiceName SERVICE_NAME_BASE = ServiceName.JBOSS.append(new String[]{"data-source"});
    private final InjectedValue<TransactionIntegration> transactionIntegrationValue = new InjectedValue();
    private final InjectedValue<Driver> driverValue = new InjectedValue();
    private final InjectedValue<ManagementRepository> managementRepositoryValue = new InjectedValue();
    private final InjectedValue<SubjectFactory> subjectFactory = new InjectedValue();
    private final String jndiName;
    private javax.sql.DataSource sqlDataSource;
    protected AS7DataSourceDeployer deployer;
    private static final SetContextLoaderAction CLEAR_ACTION = new SetContextLoaderAction(null);

    protected AbstractDataSourceService(String jndiName) {
        this.jndiName = jndiName;
    }

    public synchronized void start(StartContext startContext) throws StartException {
        try {
            ServiceContainer container = startContext.getController().getServiceContainer();
            CommonDeployment deploymentMD = this.deployer.deploy(container);
            if (deploymentMD.getCfs().length != 1) {
                throw new StartException("unable to start the ds because it generate more than one cf");
            }
            this.sqlDataSource = (javax.sql.DataSource)deploymentMD.getCfs()[0];
            log.debugf("Adding datasource: %s", (Object)deploymentMD.getCfJndiNames()[0]);
        }
        catch (Throwable t) {
            throw new StartException("Error during the deployment of " + this.jndiName, t);
        }
    }

    public synchronized void stop(StopContext stopContext) {
        this.sqlDataSource = null;
    }

    public synchronized javax.sql.DataSource getValue() throws IllegalStateException, IllegalArgumentException {
        return this.sqlDataSource;
    }

    public Injector<TransactionIntegration> getTransactionIntegrationInjector() {
        return this.transactionIntegrationValue;
    }

    public Injector<Driver> getDriverInjector() {
        return this.driverValue;
    }

    public Injector<ManagementRepository> getmanagementRepositoryInjector() {
        return this.managementRepositoryValue;
    }

    public Injector<SubjectFactory> getSubjectFactoryInjector() {
        return this.subjectFactory;
    }

    protected String buildConfigPropsString(Map<String, String> configProps) {
        StringBuffer valueBuf = new StringBuffer();
        for (Map.Entry<String, String> connProperty : configProps.entrySet()) {
            valueBuf.append(connProperty.getKey());
            valueBuf.append("=");
            valueBuf.append(connProperty.getValue());
            valueBuf.append(";");
        }
        return valueBuf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TransactionIntegration getTransactionIntegration() {
        AccessController.doPrivileged(new SetContextLoaderAction(TransactionIntegration.class.getClassLoader()));
        try {
            TransactionIntegration transactionIntegration = (TransactionIntegration)this.transactionIntegrationValue.getValue();
            return transactionIntegration;
        }
        finally {
            AccessController.doPrivileged(CLEAR_ACTION);
        }
    }

    private class MyXaMCF
    extends XAManagedConnectionFactory {
        private static final long serialVersionUID = 4876371551002746953L;

        private MyXaMCF() {
        }

        public void setXaProps(Map<String, String> inputProperties) {
            this.xaProps.putAll(inputProperties);
        }
    }

    protected class AS7DataSourceDeployer
    extends AbstractDsDeployer {
        private final DataSource dataSourceConfig;
        private final XaDataSource xaDataSourceConfig;
        private ServiceContainer serviceContainer;

        public AS7DataSourceDeployer(Logger log, XaDataSource xaDataSourceConfig) {
            super(log);
            this.xaDataSourceConfig = xaDataSourceConfig;
            this.dataSourceConfig = null;
        }

        public AS7DataSourceDeployer(Logger log, DataSource dataSourceConfig) {
            super(log);
            this.dataSourceConfig = dataSourceConfig;
            this.xaDataSourceConfig = null;
        }

        public CommonDeployment deploy(ServiceContainer serviceContainer) throws DeployException {
            try {
                if (serviceContainer == null) {
                    throw new DeployException("ServiceContainer not provided");
                }
                this.serviceContainer = serviceContainer;
                DatasourcesImpl dataSources = new DatasourcesImpl(this.dataSourceConfig != null ? Arrays.asList(this.dataSourceConfig) : null, this.xaDataSourceConfig != null ? Arrays.asList(this.xaDataSourceConfig) : null);
                CommonDeployment c = this.createObjectsAndInjectValue(new URL("file://DataSourceDeployment"), AbstractDataSourceService.this.jndiName, "uniqueJdbcLocalId", "uniqueJdbcXAId", (DataSources)dataSources, AbstractDataSourceService.class.getClassLoader());
                return c;
            }
            catch (MalformedURLException e) {
                throw new DeployException("unable to deploy", (Throwable)e);
            }
            catch (ValidateException e) {
                throw new DeployException("unable to validate and deploy ds or xads", (Throwable)e);
            }
        }

        protected ClassLoader getDeploymentClassLoader(String uniqueId) {
            return ((Driver)AbstractDataSourceService.this.driverValue.getValue()).getClass().getClassLoader();
        }

        protected String[] bindConnectionFactory(String deployment, String jndi, Object cf) throws Throwable {
            return new String[]{jndi};
        }

        protected Object initAndInject(String className, List<? extends ConfigProperty> configs, ClassLoader cl) throws DeployException {
            try {
                Class<?> clz = Class.forName(className, true, cl);
                Object o = clz.newInstance();
                if (configs != null) {
                    Injection injector = new Injection();
                    for (ConfigProperty configProperty : configs) {
                        ConfigProperty16 cpmd16;
                        if (!configProperty.isValueSet()) continue;
                        boolean setValue = true;
                        if (configProperty instanceof ConfigProperty16 && (cpmd16 = (ConfigProperty16)configProperty).getConfigPropertyIgnore() != null && cpmd16.getConfigPropertyIgnore().booleanValue()) {
                            setValue = false;
                        }
                        if (!setValue) continue;
                        injector.inject(configProperty.getConfigPropertyType().getValue(), configProperty.getConfigPropertyName().getValue(), configProperty.getConfigPropertyValue().getValue(), o);
                    }
                }
                return o;
            }
            catch (Throwable t) {
                throw new DeployException("Deployment " + className + " failed", t);
            }
        }

        protected SubjectFactory getSubjectFactory(String securityDomain) throws DeployException {
            if (securityDomain == null || securityDomain.trim().equals("")) {
                return null;
            }
            return (SubjectFactory)AbstractDataSourceService.this.subjectFactory.getValue();
        }

        public ManagementRepository getManagementRepository() {
            return (ManagementRepository)AbstractDataSourceService.this.managementRepositoryValue.getValue();
        }

        protected void initAndInjectClassLoaderPlugin(ManagedConnectionFactory mcf, CommonDataSource dsMetadata) throws DeployException {
            ((BaseWrapperManagedConnectionFactory)mcf).setClassLoaderPlugin(new ClassLoaderPlugin(){

                public ClassLoader getClassLoader() {
                    return ((Driver)AbstractDataSourceService.this.driverValue.getValue()).getClass().getClassLoader();
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public TransactionIntegration getTransactionIntegration() {
            AccessController.doPrivileged(new SetContextLoaderAction(TransactionIntegration.class.getClassLoader()));
            try {
                TransactionIntegration transactionIntegration = (TransactionIntegration)AbstractDataSourceService.this.transactionIntegrationValue.getValue();
                return transactionIntegration;
            }
            finally {
                AccessController.doPrivileged(CLEAR_ACTION);
            }
        }

        protected ManagedConnectionFactory createMcf(XaDataSource arg0, String arg1, ClassLoader arg2) throws NotFoundException, DeployException {
            MyXaMCF xaManagedConnectionFactory = new MyXaMCF();
            if (this.xaDataSourceConfig.getUrlDelimiter() != null) {
                try {
                    xaManagedConnectionFactory.setURLDelimiter(this.dataSourceConfig.getUrlDelimiter());
                }
                catch (ResourceException e) {
                    throw new DeployException("failed to get url delimiter", (Throwable)e);
                }
            }
            if (this.xaDataSourceConfig.getXaDataSourceClass() != null) {
                xaManagedConnectionFactory.setXADataSourceClass(this.xaDataSourceConfig.getXaDataSourceClass());
            }
            if (this.xaDataSourceConfig.getXaDataSourceProperty() != null) {
                xaManagedConnectionFactory.setXaProps(this.xaDataSourceConfig.getXaDataSourceProperty());
            }
            if (this.xaDataSourceConfig.getUrlSelectorStrategyClassName() != null) {
                xaManagedConnectionFactory.setUrlSelectorStrategyClassName(this.xaDataSourceConfig.getUrlSelectorStrategyClassName());
            }
            if (this.xaDataSourceConfig.getXaPool() != null && this.xaDataSourceConfig.getXaPool().isSameRmOverride() != null) {
                xaManagedConnectionFactory.setIsSameRMOverrideValue(this.xaDataSourceConfig.getXaPool().isSameRmOverride());
            }
            if (this.xaDataSourceConfig.getNewConnectionSql() != null) {
                xaManagedConnectionFactory.setNewConnectionSQL(this.xaDataSourceConfig.getNewConnectionSql());
            }
            if (this.xaDataSourceConfig.getUrlSelectorStrategyClassName() != null) {
                xaManagedConnectionFactory.setUrlSelectorStrategyClassName(this.xaDataSourceConfig.getUrlSelectorStrategyClassName());
            }
            this.setMcfProperties((BaseWrapperManagedConnectionFactory)xaManagedConnectionFactory, (CommonDataSource)this.xaDataSourceConfig, this.xaDataSourceConfig.getStatement());
            return xaManagedConnectionFactory;
        }

        protected ManagedConnectionFactory createMcf(DataSource arg0, String arg1, ClassLoader arg2) throws NotFoundException, DeployException {
            LocalManagedConnectionFactory managedConnectionFactory = new LocalManagedConnectionFactory();
            managedConnectionFactory.setUserTransactionJndiName("java:comp/UserTransaction");
            managedConnectionFactory.setDriverClass(this.dataSourceConfig.getDriverClass());
            if (this.dataSourceConfig.getConnectionProperties() != null) {
                managedConnectionFactory.setConnectionProperties(AbstractDataSourceService.this.buildConfigPropsString(this.dataSourceConfig.getConnectionProperties()));
            }
            if (this.dataSourceConfig.getConnectionUrl() != null) {
                managedConnectionFactory.setConnectionURL(this.dataSourceConfig.getConnectionUrl());
            }
            if (this.dataSourceConfig.getNewConnectionSql() != null) {
                managedConnectionFactory.setNewConnectionSQL(this.dataSourceConfig.getNewConnectionSql());
            }
            if (this.dataSourceConfig.getUrlSelectorStrategyClassName() != null) {
                managedConnectionFactory.setUrlSelectorStrategyClassName(this.dataSourceConfig.getUrlSelectorStrategyClassName());
            }
            this.setMcfProperties((BaseWrapperManagedConnectionFactory)managedConnectionFactory, (CommonDataSource)this.dataSourceConfig, this.dataSourceConfig.getStatement());
            return managedConnectionFactory;
        }

        private void setMcfProperties(BaseWrapperManagedConnectionFactory managedConnectionFactory, CommonDataSource dataSourceConfig, Statement statement) {
            Validation validation;
            TimeOut timeOut;
            DsSecurity security;
            if (dataSourceConfig.getTransactionIsolation() != null) {
                managedConnectionFactory.setTransactionIsolation(dataSourceConfig.getTransactionIsolation().name());
            }
            if ((security = dataSourceConfig.getSecurity()) != null) {
                if (security.getUserName() != null) {
                    managedConnectionFactory.setUserName(security.getUserName());
                }
                if (security.getPassword() != null) {
                    managedConnectionFactory.setPassword(security.getPassword());
                }
            }
            if ((timeOut = dataSourceConfig.getTimeOut()) != null) {
                if (timeOut.getUseTryLock() != null) {
                    managedConnectionFactory.setUseTryLock(Integer.valueOf(timeOut.getUseTryLock().intValue()));
                }
                if (timeOut.getQueryTimeout() != null) {
                    managedConnectionFactory.setQueryTimeout(Integer.valueOf(timeOut.getQueryTimeout().intValue()));
                }
            }
            if (statement != null) {
                if (statement.getTrackStatements() != null) {
                    managedConnectionFactory.setTrackStatements(statement.getTrackStatements().name());
                }
                if (statement.isSharePreparedStatements() != null) {
                    managedConnectionFactory.setSharePreparedStatements(statement.isSharePreparedStatements());
                }
                if (statement.getPreparedStatementsCacheSize() != null) {
                    managedConnectionFactory.setPreparedStatementCacheSize(Integer.valueOf(statement.getPreparedStatementsCacheSize().intValue()));
                }
            }
            if ((validation = dataSourceConfig.getValidation()) != null) {
                Extension staleConnectionChecker;
                Extension exceptionSorter;
                Extension validConnectionChecker;
                if (validation.isValidateOnMatch().booleanValue()) {
                    managedConnectionFactory.setValidateOnMatch(validation.isValidateOnMatch());
                }
                if (validation.getCheckValidConnectionSql() != null) {
                    managedConnectionFactory.setCheckValidConnectionSQL(validation.getCheckValidConnectionSql());
                }
                if ((validConnectionChecker = validation.getValidConnectionChecker()) != null) {
                    if (validConnectionChecker.getClassName() != null) {
                        managedConnectionFactory.setValidConnectionCheckerClassName(validConnectionChecker.getClassName());
                    }
                    if (validConnectionChecker.getConfigPropertiesMap() != null) {
                        managedConnectionFactory.setValidConnectionCheckerProperties(AbstractDataSourceService.this.buildConfigPropsString(validConnectionChecker.getConfigPropertiesMap()));
                    }
                }
                if ((exceptionSorter = validation.getExceptionSorter()) != null) {
                    if (exceptionSorter.getClassName() != null) {
                        managedConnectionFactory.setExceptionSorterClassName(exceptionSorter.getClassName());
                    }
                    if (exceptionSorter.getConfigPropertiesMap() != null) {
                        managedConnectionFactory.setExceptionSorterProperties(AbstractDataSourceService.this.buildConfigPropsString(exceptionSorter.getConfigPropertiesMap()));
                    }
                }
                if ((staleConnectionChecker = validation.getStaleConnectionChecker()) != null) {
                    if (staleConnectionChecker.getClassName() != null) {
                        managedConnectionFactory.setStaleConnectionCheckerClassName(staleConnectionChecker.getClassName());
                    }
                    if (staleConnectionChecker.getConfigPropertiesMap() != null) {
                        managedConnectionFactory.setStaleConnectionCheckerProperties(AbstractDataSourceService.this.buildConfigPropsString(staleConnectionChecker.getConfigPropertiesMap()));
                    }
                }
            }
        }

        protected String buildJndiName(String jndiName, Boolean javaContext) {
            return super.buildJndiName(jndiName, javaContext);
        }
    }

    private static class SetContextLoaderAction
    implements PrivilegedAction<Void> {
        private final ClassLoader classLoader;

        public SetContextLoaderAction(ClassLoader classLoader) {
            this.classLoader = classLoader;
        }

        @Override
        public Void run() {
            Thread.currentThread().setContextClassLoader(this.classLoader);
            return null;
        }
    }
}

