/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.subsystems.resourceadapters;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jboss.as.connector.subsystems.resourceadapters.ResourceAdaptersService;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.dmr.ModelNode;
import org.jboss.jca.common.api.metadata.common.CommonAdminObject;
import org.jboss.jca.common.api.metadata.common.CommonConnDef;
import org.jboss.jca.common.api.metadata.common.CommonPool;
import org.jboss.jca.common.api.metadata.common.CommonSecurity;
import org.jboss.jca.common.api.metadata.common.CommonTimeOut;
import org.jboss.jca.common.api.metadata.common.CommonValidation;
import org.jboss.jca.common.api.metadata.common.Credential;
import org.jboss.jca.common.api.metadata.common.Extension;
import org.jboss.jca.common.api.metadata.common.FlushStrategy;
import org.jboss.jca.common.api.metadata.common.Recovery;
import org.jboss.jca.common.api.metadata.common.TransactionSupportEnum;
import org.jboss.jca.common.api.metadata.resourceadapter.ResourceAdapter;
import org.jboss.jca.common.api.validator.ValidateException;
import org.jboss.jca.common.metadata.common.CommonAdminObjectImpl;
import org.jboss.jca.common.metadata.common.CommonConnDefImpl;
import org.jboss.jca.common.metadata.common.CommonPoolImpl;
import org.jboss.jca.common.metadata.common.CommonSecurityImpl;
import org.jboss.jca.common.metadata.common.CommonTimeOutImpl;
import org.jboss.jca.common.metadata.common.CommonValidationImpl;
import org.jboss.jca.common.metadata.common.CredentialImpl;
import org.jboss.jca.common.metadata.resourceadapter.ResourceAdapterImpl;

public abstract class AbstractRaOperation {
    protected ResourceAdaptersService.ModifiableResourceAdapeters buildResourceAdaptersObject(ModelNode operation) throws OperationFailedException {
        ArrayList<ResourceAdapter> resourceAdapters = new ArrayList<ResourceAdapter>();
        if (operation.hasDefined("resource-adapters")) {
            for (ModelNode raNode : operation.get("resource-adapters").asList()) {
                ResourceAdapterImpl ra;
                HashMap<String, String> configProperties = new HashMap<String, String>(raNode.get("config-properties").asList().size());
                for (ModelNode property : raNode.get("config-properties").asList()) {
                    configProperties.put(property.asProperty().getName(), property.asString());
                }
                String archive = this.getStringIfSetOrGetDefault(operation, "archive", null);
                TransactionSupportEnum transactionSupport = operation.hasDefined("transaction-support") ? TransactionSupportEnum.valueOf((String)operation.get("transaction-support").asString()) : null;
                String bootstrapContext = this.getStringIfSetOrGetDefault(operation, "bootstrapcontext", null);
                ArrayList<String> beanValidationGroups = new ArrayList<String>(operation.get("beanvalidationgroups").asList().size());
                for (ModelNode beanValidtion : operation.get("beanvalidationgroups").asList()) {
                    beanValidationGroups.add(beanValidtion.asString());
                }
                try {
                    ra = new ResourceAdapterImpl(archive, transactionSupport, this.buildConnectionDefinitionObject(operation), this.buildAdminObjects(operation), configProperties, beanValidationGroups, bootstrapContext);
                }
                catch (ValidateException e) {
                    throw new OperationFailedException((Throwable)e, operation);
                }
                resourceAdapters.add((ResourceAdapter)ra);
            }
        }
        return new ResourceAdaptersService.ModifiableResourceAdapeters(resourceAdapters);
    }

    private List<CommonConnDef> buildConnectionDefinitionObject(ModelNode parentNode) throws ValidateException {
        ArrayList<CommonConnDef> connDefs = new ArrayList<CommonConnDef>();
        for (ModelNode conDefNode : parentNode.get("connection-definitions").asList()) {
            HashMap<String, String> configProperties = new HashMap<String, String>(conDefNode.get("config-properties").asList().size());
            for (ModelNode property : conDefNode.get("config-properties").asList()) {
                configProperties.put(property.asProperty().getName(), property.asString());
            }
            String className = this.getStringIfSetOrGetDefault(conDefNode, "class-name", null);
            String jndiName = this.getStringIfSetOrGetDefault(conDefNode, "jndi-name", null);
            String poolName = this.getStringIfSetOrGetDefault(conDefNode, "pool-name", null);
            boolean enabled = this.getBooleanIfSetOrGetDefault(conDefNode, "enabled", false);
            boolean useJavaContext = this.getBooleanIfSetOrGetDefault(conDefNode, "use-java-context", false);
            boolean useCcm = this.getBooleanIfSetOrGetDefault(conDefNode, "use-ccm", true);
            Integer maxPoolSize = this.getIntIfSetOrGetDefault(conDefNode, "max-pool-size", null);
            Integer minPoolSize = this.getIntIfSetOrGetDefault(conDefNode, "min-pool-size", null);
            boolean prefill = this.getBooleanIfSetOrGetDefault(conDefNode, "pool-prefill", false);
            boolean useStrictMin = this.getBooleanIfSetOrGetDefault(conDefNode, "pool-use-strict-min", false);
            FlushStrategy flushStrategy = conDefNode.hasDefined("flush-strategy") ? FlushStrategy.valueOf((String)conDefNode.get("flush-strategy").asString()) : FlushStrategy.FAILING_CONNECTION_ONLY;
            Integer allocationRetry = this.getIntIfSetOrGetDefault(conDefNode, "allocation-retry", null);
            Long allocationRetryWaitMillis = this.getLongIfSetOrGetDefault(conDefNode, "allocation-retry-wait-millis", null);
            Long blockingTimeoutMillis = this.getLongIfSetOrGetDefault(conDefNode, "blocking-timeout-wait-millis", null);
            Long idleTimeoutMinutes = this.getLongIfSetOrGetDefault(conDefNode, "idle-timeout-minutes", null);
            Integer xaResourceTimeout = this.getIntIfSetOrGetDefault(conDefNode, "xa-resource-timeout", null);
            CommonTimeOutImpl timeOut = new CommonTimeOutImpl(blockingTimeoutMillis, idleTimeoutMinutes, allocationRetry, allocationRetryWaitMillis, xaResourceTimeout);
            CommonPoolImpl pool = new CommonPoolImpl(minPoolSize, maxPoolSize, Boolean.valueOf(prefill), Boolean.valueOf(useStrictMin), flushStrategy);
            String securityDomain = this.getStringIfSetOrGetDefault(conDefNode, "security-domain", null);
            String securityDomainAndApplication = this.getStringIfSetOrGetDefault(conDefNode, "security-domain-and-application", null);
            boolean application = this.getBooleanIfSetOrGetDefault(conDefNode, "security-application", false);
            CommonSecurityImpl security = new CommonSecurityImpl(securityDomain, securityDomainAndApplication, application);
            Long backgroundValidationMinutes = this.getLongIfSetOrGetDefault(conDefNode, "background-validation-minutes", null);
            boolean backgroundValidation = this.getBooleanIfSetOrGetDefault(conDefNode, "background-validation", false);
            boolean useFastFail = this.getBooleanIfSetOrGetDefault(conDefNode, "use-fast-fail", false);
            CommonValidationImpl validation = new CommonValidationImpl(Boolean.valueOf(backgroundValidation), backgroundValidationMinutes, Boolean.valueOf(useFastFail));
            String recoveryUsername = this.getStringIfSetOrGetDefault(conDefNode, "recovery-username", null);
            String recoveryPassword = this.getStringIfSetOrGetDefault(conDefNode, "recovery-password", null);
            String recoverySecurityDomain = this.getStringIfSetOrGetDefault(conDefNode, "recovery-security-domain", null);
            CredentialImpl credential = new CredentialImpl(recoveryUsername, recoveryPassword, recoverySecurityDomain);
            Extension recoverPlugin = this.extractExtension(conDefNode, "recovery-plugin-properties", "recovery-plugin-properties");
            boolean noRecovery = this.getBooleanIfSetOrGetDefault(conDefNode, "no-recovery", false);
            Recovery recovery = new Recovery((Credential)credential, recoverPlugin, Boolean.valueOf(noRecovery));
            CommonConnDefImpl connectionDefinition = new CommonConnDefImpl(configProperties, className, jndiName, poolName, Boolean.valueOf(enabled), Boolean.valueOf(useJavaContext), Boolean.valueOf(useCcm), (CommonPool)pool, (CommonTimeOut)timeOut, (CommonValidation)validation, (CommonSecurity)security, recovery);
            connDefs.add((CommonConnDef)connectionDefinition);
        }
        return connDefs;
    }

    private List<CommonAdminObject> buildAdminObjects(ModelNode parentNode) {
        ArrayList<CommonAdminObject> adminObjets = new ArrayList<CommonAdminObject>();
        for (ModelNode adminObject : parentNode.get("admin-objects").asList()) {
            HashMap<String, String> configProperties = new HashMap<String, String>(adminObject.get("config-properties").asList().size());
            for (ModelNode property : adminObject.get("config-properties").asList()) {
                configProperties.put(property.asProperty().getName(), property.asString());
            }
            String className = this.getStringIfSetOrGetDefault(adminObject, "class-name", null);
            String jndiName = this.getStringIfSetOrGetDefault(adminObject, "jndi-name", null);
            String poolName = this.getStringIfSetOrGetDefault(adminObject, "pool-name", null);
            boolean enabled = this.getBooleanIfSetOrGetDefault(adminObject, "enabled", false);
            boolean useJavaContext = this.getBooleanIfSetOrGetDefault(adminObject, "use-java-context", false);
            CommonAdminObjectImpl adminObjet = new CommonAdminObjectImpl(configProperties, className, jndiName, poolName, Boolean.valueOf(enabled), Boolean.valueOf(useJavaContext));
            adminObjets.add((CommonAdminObject)adminObjet);
        }
        return adminObjets;
    }

    private Long getLongIfSetOrGetDefault(ModelNode dataSourceNode, String key, Long defaultValue) {
        if (dataSourceNode.hasDefined(key)) {
            return dataSourceNode.get(key).asLong();
        }
        return defaultValue;
    }

    private Integer getIntIfSetOrGetDefault(ModelNode dataSourceNode, String key, Integer defaultValue) {
        if (dataSourceNode.hasDefined(key)) {
            return dataSourceNode.get(key).asInt();
        }
        return defaultValue;
    }

    private boolean getBooleanIfSetOrGetDefault(ModelNode dataSourceNode, String key, boolean defaultValue) {
        if (dataSourceNode.hasDefined(key)) {
            return dataSourceNode.get(key).asBoolean();
        }
        return defaultValue;
    }

    private String getStringIfSetOrGetDefault(ModelNode dataSourceNode, String key, String defaultValue) {
        if (dataSourceNode.hasDefined(key)) {
            return dataSourceNode.get(key).asString();
        }
        return defaultValue;
    }

    private Extension extractExtension(ModelNode node, String className, String propertyName) throws ValidateException {
        if (node.hasDefined(className)) {
            String exceptionSorterClassName = node.get(className).asString();
            this.getStringIfSetOrGetDefault(node, className, null);
            HashMap<String, String> exceptionSorterProperty = null;
            if (node.hasDefined(propertyName)) {
                exceptionSorterProperty = new HashMap<String, String>(node.get(propertyName).asList().size());
                for (ModelNode property : node.get(propertyName).asList()) {
                    exceptionSorterProperty.put(property.asProperty().getName(), property.asString());
                }
            }
            return new Extension(exceptionSorterClassName, exceptionSorterProperty);
        }
        return null;
    }
}

