/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.workmanager;

import java.util.concurrent.Executor;
import org.jboss.as.connector.ConnectorServices;
import org.jboss.jca.core.api.workmanager.WorkManager;
import org.jboss.jca.core.spi.transaction.xa.XATerminator;
import org.jboss.jca.core.tx.jbossts.XATerminatorImpl;
import org.jboss.logging.Logger;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.threads.BlockingExecutor;
import org.jboss.tm.JBossXATerminator;

public final class WorkManagerService
implements Service<WorkManager> {
    private final WorkManager value;
    private final InjectedValue<Executor> executorShort = new InjectedValue();
    private final InjectedValue<Executor> executorLong = new InjectedValue();
    private final InjectedValue<JBossXATerminator> xaTerminator = new InjectedValue();
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.connector");

    public WorkManagerService(WorkManager value) {
        log.debugf("Building WorkManager", new Object[0]);
        this.value = value;
    }

    public WorkManager getValue() throws IllegalStateException {
        return ConnectorServices.notNull(this.value);
    }

    public void start(StartContext context) throws StartException {
        this.value.setLongRunningThreadPool((BlockingExecutor)this.executorLong.getValue());
        this.value.setShortRunningThreadPool((BlockingExecutor)this.executorShort.getValue());
        this.value.setXATerminator((XATerminator)new XATerminatorImpl((JBossXATerminator)this.xaTerminator.getValue()));
        log.debugf("Starting JCA WorkManager", new Object[0]);
    }

    public void stop(StopContext context) {
    }

    public Injector<Executor> getExecutorShortInjector() {
        return this.executorShort;
    }

    public Injector<Executor> getExecutorLongInjector() {
        return this.executorLong;
    }

    public Injector<JBossXATerminator> getXaTerminatorInjector() {
        return this.xaTerminator;
    }
}

